/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.datamodeling.marshallers;

import software.amazon.awssdk.services.dynamodb.datamodeling.ArgumentMarshaller;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbMappingException;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbMarshaller;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public class CustomMarshaller
implements ArgumentMarshaller.StringAttributeMarshaller {
    private final Class<? extends DynamoDbMarshaller<?>> marshallerClass;

    public CustomMarshaller(Class<? extends DynamoDbMarshaller<?>> marshallerClass) {
        this.marshallerClass = marshallerClass;
    }

    private static DynamoDbMarshaller<Object> createMarshaller(Class<?> clazz) {
        try {
            return (DynamoDbMarshaller)clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new DynamoDbMappingException("Failed to instantiate custom marshaler for class " + clazz, e);
        }
        catch (IllegalAccessException e) {
            throw new DynamoDbMappingException("Failed to instantiate custom marshaler for class " + clazz, e);
        }
    }

    @Override
    public AttributeValue marshall(Object obj) {
        DynamoDbMarshaller<Object> marshaler = CustomMarshaller.createMarshaller(this.marshallerClass);
        String stringValue = marshaler.marshall(obj);
        if (stringValue == null) {
            return null;
        }
        return (AttributeValue)AttributeValue.builder().s(stringValue).build();
    }
}

