/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.datamodeling.marshallers;

import java.util.ArrayList;
import java.util.Collection;
import software.amazon.awssdk.services.dynamodb.datamodeling.ArgumentMarshaller;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public class CollectionToListMarshaller
implements ArgumentMarshaller.ListAttributeMarshaller {
    private static final CollectionToListMarshaller INSTANCE = new CollectionToListMarshaller();
    private final ArgumentMarshaller memberMarshaller;

    private CollectionToListMarshaller() {
        this(null);
    }

    public CollectionToListMarshaller(ArgumentMarshaller memberMarshaller) {
        this.memberMarshaller = memberMarshaller;
    }

    public static CollectionToListMarshaller instance() {
        return INSTANCE;
    }

    @Override
    public AttributeValue marshall(Object obj) {
        if (this.memberMarshaller == null) {
            throw new IllegalStateException("No member marshaller configured!");
        }
        Collection objects = (Collection)obj;
        ArrayList<AttributeValue> values = new ArrayList<AttributeValue>(objects.size());
        for (Object o : objects) {
            AttributeValue value = o == null ? (AttributeValue)AttributeValue.builder().nul(true).build() : this.memberMarshaller.marshall(o);
            values.add(value);
        }
        AttributeValue result = (AttributeValue)AttributeValue.builder().l(values).build();
        return result;
    }

    public ArgumentMarshaller memberMarshaller() {
        return this.memberMarshaller;
    }
}

