/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.datamodeling;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.SdkBaseException;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.auth.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.retry.RetryUtils;
import software.amazon.awssdk.services.dynamodb.DynamoDBClient;
import software.amazon.awssdk.services.dynamodb.datamodeling.AbstractDynamoDbMapper;
import software.amazon.awssdk.services.dynamodb.datamodeling.AttributeTransformer;
import software.amazon.awssdk.services.dynamodb.datamodeling.BatchLoadContext;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbAutoGenerateStrategy;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbDeleteExpression;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbMapperConfig;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbMapperFieldModel;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbMapperModelFactory;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbMapperTableModel;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbMappingException;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbQueryExpression;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbSaveExpression;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbScanExpression;
import software.amazon.awssdk.services.dynamodb.datamodeling.DynamoDbTableMapper;
import software.amazon.awssdk.services.dynamodb.datamodeling.KeyPair;
import software.amazon.awssdk.services.dynamodb.datamodeling.PaginatedParallelScanList;
import software.amazon.awssdk.services.dynamodb.datamodeling.PaginatedQueryList;
import software.amazon.awssdk.services.dynamodb.datamodeling.PaginatedScanList;
import software.amazon.awssdk.services.dynamodb.datamodeling.ParallelScanTask;
import software.amazon.awssdk.services.dynamodb.datamodeling.QueryResultPage;
import software.amazon.awssdk.services.dynamodb.datamodeling.S3ClientCache;
import software.amazon.awssdk.services.dynamodb.datamodeling.S3Link;
import software.amazon.awssdk.services.dynamodb.datamodeling.ScanResultPage;
import software.amazon.awssdk.services.dynamodb.datamodeling.StandardModelFactories;
import software.amazon.awssdk.services.dynamodb.model.AttributeAction;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.AttributeValueUpdate;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemResponse;
import software.amazon.awssdk.services.dynamodb.model.Condition;
import software.amazon.awssdk.services.dynamodb.model.ConditionalOperator;
import software.amazon.awssdk.services.dynamodb.model.CreateTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteTableRequest;
import software.amazon.awssdk.services.dynamodb.model.ExpectedAttributeValue;
import software.amazon.awssdk.services.dynamodb.model.GetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.GetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.KeyType;
import software.amazon.awssdk.services.dynamodb.model.KeysAndAttributes;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;
import software.amazon.awssdk.services.dynamodb.model.PutItemResponse;
import software.amazon.awssdk.services.dynamodb.model.PutRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryResponse;
import software.amazon.awssdk.services.dynamodb.model.ReturnValue;
import software.amazon.awssdk.services.dynamodb.model.ScalarAttributeType;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.model.ScanResponse;
import software.amazon.awssdk.services.dynamodb.model.Select;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemResponse;
import software.amazon.awssdk.services.dynamodb.model.WriteRequest;
import software.amazon.awssdk.util.VersionInfoUtils;

public class DynamoDbMapper
extends AbstractDynamoDbMapper {
    protected static final long MAX_BACKOFF_IN_MILLISECONDS = 3000L;
    protected static final int MAX_ITEMS_PER_BATCH = 25;
    protected static final int BATCH_GET_MAX_RETRY_COUNT_ALL_KEYS = 5;
    private static final String USER_AGENT = DynamoDbMapper.class.getName() + "/" + VersionInfoUtils.getVersion();
    private static final String USER_AGENT_BATCH_OPERATION = DynamoDbMapper.class.getName() + "_batch_operation/" + VersionInfoUtils.getVersion();
    private static final Log log = LogFactory.getLog(DynamoDbMapper.class);
    private final DynamoDBClient db;
    private final DynamoDbMapperModelFactory models;
    private final S3Link.Factory s3Links;
    private final AttributeTransformer transformer;

    public DynamoDbMapper(DynamoDBClient dynamoDb) {
        this(dynamoDb, DynamoDbMapperConfig.DEFAULT, null, null);
    }

    public DynamoDbMapper(DynamoDBClient dynamoDb, DynamoDbMapperConfig config) {
        this(dynamoDb, config, null, null);
    }

    public DynamoDbMapper(DynamoDBClient ddb, AwsCredentialsProvider s3CredentialProvider) {
        this(ddb, DynamoDbMapperConfig.DEFAULT, s3CredentialProvider);
    }

    public DynamoDbMapper(DynamoDBClient dynamoDb, DynamoDbMapperConfig config, AttributeTransformer transformer) {
        this(dynamoDb, config, transformer, null);
    }

    public DynamoDbMapper(DynamoDBClient dynamoDb, DynamoDbMapperConfig config, AwsCredentialsProvider s3CredentialProvider) {
        this(dynamoDb, config, null, DynamoDbMapper.validate(s3CredentialProvider));
    }

    public DynamoDbMapper(DynamoDBClient dynamoDb, DynamoDbMapperConfig config, AttributeTransformer transformer, AwsCredentialsProvider s3CredentialsProvider) {
        super(config);
        DynamoDbMapper.failFastOnIncompatibleSubclass(this.getClass());
        this.db = dynamoDb;
        this.transformer = transformer;
        this.s3Links = S3Link.Factory.of(s3CredentialsProvider);
        this.models = StandardModelFactories.of(this.s3Links);
    }

    private static void failFastOnIncompatibleSubclass(Class<?> clazz) {
        while (clazz != DynamoDbMapper.class) {
            Object[] classOverride = new Class[]{Class.class, Map.class};
            Object[] nameOverride = new Class[]{String.class, String.class, Map.class};
            for (Method method : clazz.getDeclaredMethods()) {
                Object[] params;
                if (!method.getName().equals("transformAttributes") || !Arrays.equals(params = method.getParameterTypes(), classOverride) && !Arrays.equals(params, nameOverride)) continue;
                throw new IllegalStateException("The deprecated transformAttributes method is no longer supported as of 1.9.0. Use an AttributeTransformer to inject custom attribute transformation logic.");
            }
            clazz = clazz.getSuperclass();
        }
    }

    private static AwsCredentialsProvider validate(AwsCredentialsProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("s3 credentials provider must not be null");
        }
        return provider;
    }

    private static <K, V> boolean isNullOrEmpty(Map<K, V> map) {
        return map == null || map.isEmpty();
    }

    private static <T> boolean anyKeyGeneratable(DynamoDbMapperTableModel<T> model, T object, DynamoDbMapperConfig.SaveBehavior saveBehavior) {
        for (DynamoDbMapperFieldModel<T, Object> field : model.keys()) {
            if (!DynamoDbMapper.canGenerate(model, object, saveBehavior, field)) continue;
            return true;
        }
        return false;
    }

    private static <T> boolean canGenerate(DynamoDbMapperTableModel<T> model, T object, DynamoDbMapperConfig.SaveBehavior saveBehavior, DynamoDbMapperFieldModel<T, Object> field) {
        if (field.getGenerateStrategy() == null) {
            return false;
        }
        if (field.getGenerateStrategy() == DynamoDbAutoGenerateStrategy.ALWAYS) {
            return true;
        }
        if (field.get(object) != null) {
            return false;
        }
        if (field.keyType() != null || field.indexed()) {
            return true;
        }
        if (saveBehavior == DynamoDbMapperConfig.SaveBehavior.CLOBBER) {
            return true;
        }
        if (saveBehavior == DynamoDbMapperConfig.SaveBehavior.UPDATE) {
            return true;
        }
        return DynamoDbMapper.anyKeyGeneratable(model, object, saveBehavior);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static <T> QueryRequest processKeyConditions(QueryRequest queryRequest, DynamoDbQueryExpression<T> expression, DynamoDbMapperTableModel<T> model) {
        boolean userProvidedGsi;
        LinkedHashMap<String, Condition> hashKeyConditions = new LinkedHashMap<String, Condition>();
        if (expression.getHashKeyValues() != null) {
            for (DynamoDbMapperFieldModel<T, Object> field : model.fields()) {
                Object value;
                if (field.keyType() != KeyType.HASH && field.globalSecondaryIndexNames(KeyType.HASH).isEmpty() || (value = field.get(expression.getHashKeyValues())) == null) continue;
                hashKeyConditions.put(field.name(), field.eq(value));
            }
        }
        Map<String, Condition> rangeKeyConditions = expression.getRangeKeyConditions();
        String keyCondExpression = queryRequest.keyConditionExpression();
        if (keyCondExpression == null) {
            if (DynamoDbMapper.isNullOrEmpty(hashKeyConditions)) {
                throw new IllegalArgumentException("Illegal query expression: No hash key condition is found in the query");
            }
        } else {
            if (!DynamoDbMapper.isNullOrEmpty(hashKeyConditions)) {
                throw new IllegalArgumentException("Illegal query expression: Either the hash key conditions or the key condition expression must be specified but not both.");
            }
            if (DynamoDbMapper.isNullOrEmpty(rangeKeyConditions)) return queryRequest;
            throw new IllegalArgumentException("Illegal query expression: The range key conditions can only be specified when the key condition expression is not specified.");
        }
        if (rangeKeyConditions != null && rangeKeyConditions.size() > 1) {
            throw new IllegalArgumentException("Illegal query expression: Conditions on multiple range keys (" + rangeKeyConditions.keySet().toString() + ") are found in the query. DynamoDB service only accepts up to ONE range key condition.");
        }
        boolean hasRangeKeyCondition = rangeKeyConditions != null && !rangeKeyConditions.isEmpty();
        String userProvidedIndexName = queryRequest.indexName();
        String primaryHashKeyName = model.hashKey().name();
        boolean hasPrimaryHashKeyCondition = false;
        HashMap annotatedGsisOnHashKeys = new HashMap();
        String hashKeyNameForThisQuery = null;
        boolean hasPrimaryRangeKeyCondition = false;
        HashSet<String> annotatedLsisOnRangeKey = new HashSet<String>();
        HashSet<String> annotatedGsisOnRangeKey = new HashSet<String>();
        String rangeKeyNameForThisQuery = null;
        if (hasRangeKeyCondition) {
            Iterator<String> iterator = rangeKeyConditions.keySet().iterator();
            while (iterator.hasNext()) {
                String rangeKeyName;
                rangeKeyNameForThisQuery = rangeKeyName = iterator.next();
                DynamoDbMapperFieldModel rk = model.field(rangeKeyName);
                if (rk.keyType() == KeyType.RANGE) {
                    hasPrimaryRangeKeyCondition = true;
                }
                annotatedLsisOnRangeKey.addAll(rk.localSecondaryIndexNames());
                annotatedGsisOnRangeKey.addAll(rk.globalSecondaryIndexNames(KeyType.RANGE));
            }
            if (!hasPrimaryRangeKeyCondition && annotatedLsisOnRangeKey.isEmpty() && annotatedGsisOnRangeKey.isEmpty()) {
                throw new DynamoDbMappingException("The query contains a condition on a range key (" + rangeKeyNameForThisQuery + ") that is not annotated with either @DynamoDBRangeKey or @DynamoDBIndexRangeKey.");
            }
        }
        boolean userProvidedLsiWithRangeKeyCondition = userProvidedIndexName != null && annotatedLsisOnRangeKey.contains(userProvidedIndexName);
        boolean hashOnlyLsiQuery = userProvidedIndexName != null && !hasRangeKeyCondition && model.localSecondaryIndex(userProvidedIndexName) != null;
        boolean userProvidedLsi = userProvidedLsiWithRangeKeyCondition || hashOnlyLsiQuery;
        boolean userProvidedGsiWithRangeKeyCondition = userProvidedIndexName != null && annotatedGsisOnRangeKey.contains(userProvidedIndexName);
        boolean hashOnlyGsiQuery = userProvidedIndexName != null && !hasRangeKeyCondition && model.globalSecondaryIndex(userProvidedIndexName) != null;
        boolean bl = userProvidedGsi = userProvidedGsiWithRangeKeyCondition || hashOnlyGsiQuery;
        if (userProvidedLsi && userProvidedGsi) {
            throw new DynamoDbMappingException("Invalid query: Index \"" + userProvidedIndexName + "\" is annotateded as both a LSI and a GSI for attribute.");
        }
        for (String hashKeyName : hashKeyConditions.keySet()) {
            Object hk;
            List<String> list;
            if (hashKeyName.equals(primaryHashKeyName)) {
                hasPrimaryHashKeyCondition = true;
            }
            annotatedGsisOnHashKeys.put(hashKeyName, (list = ((DynamoDbMapperFieldModel)(hk = model.field(hashKeyName))).globalSecondaryIndexNames(KeyType.HASH)) == null ? new HashSet() : new HashSet<String>(list));
            if (userProvidedIndexName == null) continue;
            boolean foundHashKeyConditionValidWithUserProvidedIndex = false;
            if (userProvidedLsi && hashKeyName.equals(primaryHashKeyName)) {
                foundHashKeyConditionValidWithUserProvidedIndex = true;
            } else if (userProvidedGsi && list != null && list.contains(userProvidedIndexName)) {
                foundHashKeyConditionValidWithUserProvidedIndex = true;
            }
            if (!foundHashKeyConditionValidWithUserProvidedIndex) continue;
            if (hashKeyNameForThisQuery != null) {
                throw new IllegalArgumentException("Ambiguous query expression: More than one hash key EQ conditions (" + hashKeyNameForThisQuery + ", " + hashKeyName + ") are applicable to the specified index (" + userProvidedIndexName + "). Please provide only one of them in the query expression.");
            }
            hashKeyNameForThisQuery = hashKeyName;
        }
        HashMap<String, Condition> keyConditions = new HashMap<String, Condition>();
        if (userProvidedIndexName != null) {
            if (hasRangeKeyCondition && !userProvidedLsi && !userProvidedGsi) {
                throw new IllegalArgumentException("Illegal query expression: No range key condition is applicable to the specified index (" + userProvidedIndexName + "). ");
            }
            if (hashKeyNameForThisQuery == null) {
                throw new IllegalArgumentException("Illegal query expression: No hash key condition is applicable to the specified index (" + userProvidedIndexName + "). ");
            }
            keyConditions.put(hashKeyNameForThisQuery, (Condition)hashKeyConditions.get(hashKeyNameForThisQuery));
            if (!hasRangeKeyCondition) return (QueryRequest)((Object)queryRequest.toBuilder().keyConditions(keyConditions).build());
            keyConditions.putAll(rangeKeyConditions);
            return (QueryRequest)((Object)queryRequest.toBuilder().keyConditions(keyConditions).build());
        } else if (hasRangeKeyCondition) {
            String inferredIndexName = null;
            hashKeyNameForThisQuery = null;
            if (hasPrimaryHashKeyCondition && hasPrimaryRangeKeyCondition) {
                hashKeyNameForThisQuery = primaryHashKeyName;
            } else {
                for (Map.Entry entry : annotatedGsisOnHashKeys.entrySet()) {
                    String hashKeyName = (String)entry.getKey();
                    Set annotatedGsisOnHashKey = (Set)entry.getValue();
                    boolean foundValidQueryExpressionWithInferredIndex = false;
                    String indexNameInferredByThisHashKey = null;
                    if (hashKeyName.equals(primaryHashKeyName) && annotatedLsisOnRangeKey.size() == 1) {
                        foundValidQueryExpressionWithInferredIndex = true;
                        indexNameInferredByThisHashKey = (String)annotatedLsisOnRangeKey.iterator().next();
                    }
                    annotatedGsisOnHashKey.retainAll(annotatedGsisOnRangeKey);
                    if (annotatedGsisOnHashKey.size() == 1) {
                        if (foundValidQueryExpressionWithInferredIndex) {
                            hashKeyNameForThisQuery = hashKeyName;
                            inferredIndexName = indexNameInferredByThisHashKey;
                        }
                        foundValidQueryExpressionWithInferredIndex = true;
                        indexNameInferredByThisHashKey = (String)annotatedGsisOnHashKey.iterator().next();
                    }
                    if (!foundValidQueryExpressionWithInferredIndex) continue;
                    if (hashKeyNameForThisQuery != null) {
                        throw new IllegalArgumentException("Ambiguous query expression: Found multiple valid queries: (Hash: \"" + hashKeyNameForThisQuery + "\", Range: \"" + rangeKeyNameForThisQuery + "\", Index: \"" + inferredIndexName + "\") and (Hash: \"" + hashKeyName + "\", Range: \"" + rangeKeyNameForThisQuery + "\", Index: \"" + indexNameInferredByThisHashKey + "\").");
                    }
                    hashKeyNameForThisQuery = hashKeyName;
                    inferredIndexName = indexNameInferredByThisHashKey;
                }
            }
            if (hashKeyNameForThisQuery == null) throw new IllegalArgumentException("Illegal query expression: Cannot infer the index name from the query expression.");
            keyConditions.put(hashKeyNameForThisQuery, (Condition)hashKeyConditions.get(hashKeyNameForThisQuery));
            keyConditions.putAll(rangeKeyConditions);
            queryRequest = (QueryRequest)((Object)queryRequest.toBuilder().indexName(inferredIndexName).build());
            return (QueryRequest)((Object)queryRequest.toBuilder().keyConditions(keyConditions).build());
        } else if (hashKeyConditions.size() > 1) {
            if (!hasPrimaryHashKeyCondition) throw new IllegalArgumentException("Ambiguous query expression: More than one index hash key EQ conditions (" + hashKeyConditions.keySet() + ") are applicable to the query. Please provide only one of them in the query expression, or specify the appropriate index name.");
            keyConditions.put(primaryHashKeyName, (Condition)hashKeyConditions.get(primaryHashKeyName));
            return (QueryRequest)((Object)queryRequest.toBuilder().keyConditions(keyConditions).build());
        } else {
            Map.Entry entry = annotatedGsisOnHashKeys.entrySet().iterator().next();
            String hashKeyName = (String)entry.getKey();
            Set set = (Set)entry.getValue();
            if (!hasPrimaryHashKeyCondition) {
                if (set.size() == 1) {
                    queryRequest = (QueryRequest)((Object)queryRequest.toBuilder().indexName((String)set.iterator().next()).build());
                } else {
                    if (set.size() <= 1) throw new IllegalArgumentException("Illegal query expression: No GSI is found in the @DynamoDBIndexHashKey annotation for attribute \"" + hashKeyName + "\".");
                    throw new IllegalArgumentException("Ambiguous query expression: More than one GSIs (" + set + ") are applicable to the query. Please specify one of them in your query expression.");
                }
            }
            keyConditions.putAll(hashKeyConditions);
        }
        return (QueryRequest)((Object)queryRequest.toBuilder().keyConditions(keyConditions).build());
    }

    private static Map<String, ExpectedAttributeValue> mergeExpectedAttributeValueConditions(Map<String, ExpectedAttributeValue> internalAssertions, Map<String, ExpectedAttributeValue> userProvidedConditions, String userProvidedConditionOperator) {
        if ((internalAssertions == null || internalAssertions.isEmpty()) && (userProvidedConditions == null || userProvidedConditions.isEmpty())) {
            return null;
        }
        if (internalAssertions == null) {
            return new HashMap<String, ExpectedAttributeValue>(userProvidedConditions);
        }
        if (userProvidedConditions == null) {
            return new HashMap<String, ExpectedAttributeValue>(internalAssertions);
        }
        HashMap<String, ExpectedAttributeValue> mergedExpectedValues = new HashMap<String, ExpectedAttributeValue>(internalAssertions);
        for (String attrName : userProvidedConditions.keySet()) {
            mergedExpectedValues.remove(attrName);
        }
        if (ConditionalOperator.OR.toString().equals(userProvidedConditionOperator) && !mergedExpectedValues.isEmpty()) {
            throw new IllegalArgumentException("Unable to assert the value of the fields " + mergedExpectedValues.keySet() + ", since the expected value conditions cannot be combined with user-specified conditions joined by \"OR\". You can use SaveBehavior.CLOBBER to skip the assertion on these fields.");
        }
        mergedExpectedValues.putAll(userProvidedConditions);
        return mergedExpectedValues;
    }

    static <X extends AmazonWebServiceRequest> X applyUserAgent(X request) {
        request.getRequestClientOptions().appendUserAgent(USER_AGENT);
        return request;
    }

    static <X extends AmazonWebServiceRequest> X applyBatchOperationUserAgent(X request) {
        request.getRequestClientOptions().appendUserAgent(USER_AGENT_BATCH_OPERATION);
        return request;
    }

    private static void pause(long delay) {
        if (delay <= 0L) {
            return;
        }
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SdkClientException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public <T> DynamoDbMapperTableModel<T> getTableModel(Class<T> clazz, DynamoDbMapperConfig config) {
        return this.models.getTableFactory(config).getTable(clazz);
    }

    @Override
    public <T> T load(T keyObject, DynamoDbMapperConfig config) {
        Class<?> clazz = keyObject.getClass();
        config = this.mergeConfig(config);
        DynamoDbMapperTableModel<?> model = this.getTableModel(clazz, config);
        String tableName = this.getTableName(clazz, keyObject, config);
        GetItemRequest.Builder rqBuilder = GetItemRequest.builder();
        Map<String, AttributeValue> key = model.convertKey(keyObject);
        rqBuilder.key(key);
        rqBuilder.tableName(tableName);
        rqBuilder.consistentRead(config.getConsistentReads() == DynamoDbMapperConfig.ConsistentReads.CONSISTENT);
        GetItemRequest rq = (GetItemRequest)((GetItemRequest)((Object)rqBuilder.build())).withRequestMetricCollector(config.getRequestMetricCollector());
        GetItemResponse item = this.db.getItem(DynamoDbMapper.applyUserAgent(rq));
        Map<String, AttributeValue> itemAttributes = item.item();
        if (itemAttributes == null) {
            return null;
        }
        Object object = this.privateMarshallIntoObject(this.toParameters(itemAttributes, clazz, tableName, config));
        return (T)object;
    }

    @Override
    public <T> T load(Class<T> clazz, Object hashKey, Object rangeKey, DynamoDbMapperConfig config) {
        config = this.mergeConfig(config);
        DynamoDbMapperTableModel<T> model = this.getTableModel(clazz, config);
        T keyObject = model.createKey(hashKey, rangeKey);
        return this.load(keyObject, config);
    }

    @Override
    public <T> T marshallIntoObject(Class<T> clazz, Map<String, AttributeValue> itemAttributes, DynamoDbMapperConfig config) {
        config = this.mergeConfig(config);
        String tableName = this.getTableName(clazz, config);
        return this.privateMarshallIntoObject(this.toParameters(itemAttributes, clazz, tableName, config));
    }

    private <T> T privateMarshallIntoObject(AttributeTransformer.Parameters<T> parameters) {
        Class<T> clazz = parameters.modelClass();
        Map<String, AttributeValue> values = this.untransformAttributes(parameters);
        DynamoDbMapperTableModel<T> model = this.getTableModel(clazz, parameters.mapperConfig());
        return model.unconvert(values);
    }

    @Override
    public <T> List<T> marshallIntoObjects(Class<T> clazz, List<Map<String, AttributeValue>> itemAttributes, DynamoDbMapperConfig config) {
        ArrayList<T> result = new ArrayList<T>(itemAttributes.size());
        for (Map<String, AttributeValue> item : itemAttributes) {
            result.add(this.marshallIntoObject(clazz, item));
        }
        return result;
    }

    final <T> List<T> marshallIntoObjects(List<AttributeTransformer.Parameters<T>> parameters) {
        ArrayList<T> result = new ArrayList<T>(parameters.size());
        for (AttributeTransformer.Parameters<T> entry : parameters) {
            result.add(this.privateMarshallIntoObject(entry));
        }
        return result;
    }

    @Override
    public <T> void save(T object, DynamoDbSaveExpression saveExpression, DynamoDbMapperConfig config) {
        DynamoDbMapperConfig finalConfig = this.mergeConfig(config);
        Class<?> clazz = object.getClass();
        String tableName = this.getTableName(clazz, object, finalConfig);
        DynamoDbMapperTableModel<?> model = this.getTableModel(clazz, finalConfig);
        boolean forcePut = finalConfig.saveBehavior() == DynamoDbMapperConfig.SaveBehavior.CLOBBER || DynamoDbMapper.anyKeyGeneratable(model, object, finalConfig.saveBehavior());
        SaveObjectHandler saveObjectHandler = forcePut ? new SaveObjectHandler(this, clazz, object, tableName, finalConfig, saveExpression){
            {
                DynamoDbMapper dynamoDbMapper = x0;
                dynamoDbMapper.getClass();
                super(clazz, object, tableName, saveConfig, saveExpression);
            }

            @Override
            protected void onPrimaryKeyAttributeValue(String attributeName, AttributeValue keyAttributeValue) {
                this.getAttributeValueUpdates().put(attributeName, (AttributeValueUpdate)AttributeValueUpdate.builder().value(keyAttributeValue).action("PUT").build());
            }

            @Override
            protected void onNullNonKeyAttribute(String attributeName) {
            }

            @Override
            protected void executeLowLevelRequest() {
                this.doPutItem();
            }
        } : new SaveObjectHandler(this, clazz, object, tableName, finalConfig, saveExpression){
            {
                DynamoDbMapper dynamoDbMapper = x0;
                dynamoDbMapper.getClass();
                super(clazz, object, tableName, saveConfig, saveExpression);
            }

            @Override
            protected void onPrimaryKeyAttributeValue(String attributeName, AttributeValue keyAttributeValue) {
                this.getPrimaryKeyAttributeValues().put(attributeName, keyAttributeValue);
            }

            @Override
            protected void onNonKeyAttribute(String attributeName, AttributeValue currentValue) {
                if (this.localSaveBehavior() == DynamoDbMapperConfig.SaveBehavior.APPEND_SET && (currentValue.bs() != null || currentValue.ns() != null || currentValue.ss() != null)) {
                    this.getAttributeValueUpdates().put(attributeName, (AttributeValueUpdate)AttributeValueUpdate.builder().value(currentValue).action("ADD").build());
                    return;
                }
                super.onNonKeyAttribute(attributeName, currentValue);
            }

            @Override
            protected void onNullNonKeyAttribute(String attributeName) {
                if (this.localSaveBehavior() == DynamoDbMapperConfig.SaveBehavior.UPDATE_SKIP_NULL_ATTRIBUTES || this.localSaveBehavior() == DynamoDbMapperConfig.SaveBehavior.APPEND_SET) {
                    return;
                }
                this.getAttributeValueUpdates().put(attributeName, (AttributeValueUpdate)AttributeValueUpdate.builder().action("DELETE").build());
            }

            @Override
            protected void executeLowLevelRequest() {
                UpdateItemResponse updateItemResult = this.doUpdateItem();
                if (updateItemResult.attributes() == null || updateItemResult.attributes().isEmpty()) {
                    for (String keyAttributeName : this.getPrimaryKeyAttributeValues().keySet()) {
                        AttributeValueUpdate value = (AttributeValueUpdate)AttributeValueUpdate.builder().value(this.getPrimaryKeyAttributeValues().get(keyAttributeName)).action("PUT").build();
                        this.getAttributeValueUpdates().put(keyAttributeName, value);
                    }
                    this.doPutItem();
                }
            }
        };
        saveObjectHandler.execute();
    }

    @Override
    public <T> void delete(T object, DynamoDbDeleteExpression deleteExpression, DynamoDbMapperConfig config) {
        Iterator<DynamoDbMapperFieldModel<?, Object>> iterator;
        config = this.mergeConfig(config);
        Class<?> clazz = object.getClass();
        DynamoDbMapperTableModel<?> model = this.getTableModel(clazz, config);
        String tableName = this.getTableName(clazz, object, config);
        Map<String, AttributeValue> key = model.convertKey(object);
        HashMap<String, ExpectedAttributeValue> internalAssertions = new HashMap<String, ExpectedAttributeValue>();
        if (config.saveBehavior() != DynamoDbMapperConfig.SaveBehavior.CLOBBER && model.versioned() && (iterator = model.versions().iterator()).hasNext()) {
            DynamoDbMapperFieldModel<?, Object> field = iterator.next();
            AttributeValue current = field.getAndConvert(object);
            if (current == null) {
                internalAssertions.put(field.name(), (ExpectedAttributeValue)ExpectedAttributeValue.builder().exists(false).build());
            } else {
                internalAssertions.put(field.name(), (ExpectedAttributeValue)ExpectedAttributeValue.builder().exists(true).value(current).build());
            }
        }
        DeleteItemRequest req = (DeleteItemRequest)((Object)DeleteItemRequest.builder().key(key).tableName(tableName).expected(internalAssertions).build());
        if (deleteExpression != null) {
            String conditionalExpression = deleteExpression.getConditionExpression();
            if (conditionalExpression != null) {
                if (!internalAssertions.isEmpty()) {
                    throw new SdkClientException("Condition Expressions cannot be used if a versioned attribute is present");
                }
                req = (DeleteItemRequest)((Object)req.toBuilder().conditionExpression(conditionalExpression).expressionAttributeNames(deleteExpression.getExpressionAttributeNames()).expressionAttributeValues(deleteExpression.getExpressionAttributeValues()).build());
            }
            req = (DeleteItemRequest)((Object)req.toBuilder().expected(DynamoDbMapper.mergeExpectedAttributeValueConditions(internalAssertions, deleteExpression.getExpected(), deleteExpression.getConditionalOperator())).conditionalOperator(deleteExpression.getConditionalOperator()).build());
        }
        this.db.deleteItem((DeleteItemRequest)DynamoDbMapper.applyUserAgent(req.withRequestMetricCollector(config.getRequestMetricCollector())));
    }

    @Override
    public List<FailedBatch> batchWrite(Iterable<? extends Object> objectsToWrite, Iterable<? extends Object> objectsToDelete, DynamoDbMapperConfig config) {
        String tableName;
        Class<?> clazz;
        config = this.mergeConfig(config);
        LinkedList<FailedBatch> totalFailedBatches = new LinkedList<FailedBatch>();
        StringListMap<Object> requestItems = new StringListMap<Object>();
        LinkedList<ValueUpdate> inMemoryUpdates = new LinkedList<ValueUpdate>();
        for (Object object : objectsToWrite) {
            clazz = object.getClass();
            tableName = this.getTableName(clazz, object, config);
            HashMap<String, AttributeValue> attributeValues = new HashMap<String, AttributeValue>();
            DynamoDbMapperTableModel<?> model = this.getTableModel(clazz, config);
            for (DynamoDbMapperFieldModel<Object, Object> dynamoDbMapperFieldModel : model.fields()) {
                Object currentValue;
                if (DynamoDbMapper.canGenerate(model, object, config.saveBehavior(), dynamoDbMapperFieldModel) && !dynamoDbMapperFieldModel.versioned()) {
                    currentValue = dynamoDbMapperFieldModel.convert(dynamoDbMapperFieldModel.generate(dynamoDbMapperFieldModel.get(object)));
                    inMemoryUpdates.add(new ValueUpdate(dynamoDbMapperFieldModel, (AttributeValue)currentValue, object));
                } else {
                    currentValue = dynamoDbMapperFieldModel.convert(dynamoDbMapperFieldModel.get(object));
                }
                if (currentValue == null) continue;
                attributeValues.put(dynamoDbMapperFieldModel.name(), (AttributeValue)currentValue);
            }
            if (!requestItems.containsKey(tableName)) {
                requestItems.put(tableName, new LinkedList());
            }
            AttributeTransformer.Parameters<?> parameters = this.toParameters(attributeValues, clazz, tableName, config);
            requestItems.add(tableName, WriteRequest.builder().putRequest((PutRequest)PutRequest.builder().item(this.transformAttributes(parameters)).build()).build());
        }
        for (Object object : objectsToDelete) {
            clazz = object.getClass();
            tableName = this.getTableName(clazz, object, config);
            DynamoDbMapperTableModel<?> model = this.getTableModel(clazz, config);
            Map<String, AttributeValue> key = model.convertKey(object);
            requestItems.add(tableName, WriteRequest.builder().deleteRequest((DeleteRequest)DeleteRequest.builder().key(key).build()).build());
        }
        for (StringListMap stringListMap : requestItems.subMaps(25, true)) {
            List<FailedBatch> failedBatches = this.writeOneBatch(stringListMap, config.batchWriteRetryStrategy());
            totalFailedBatches.addAll(failedBatches);
            if (!this.containsThrottlingException(failedBatches)) continue;
            DynamoDbMapper.pause(config.batchWriteRetryStrategy().getDelayBeforeRetryUnprocessedItems(Collections.unmodifiableMap(stringListMap), 0));
        }
        for (ValueUpdate valueUpdate : inMemoryUpdates) {
            valueUpdate.apply();
        }
        return totalFailedBatches;
    }

    private List<FailedBatch> writeOneBatch(StringListMap<WriteRequest> batch, DynamoDbMapperConfig.BatchWriteRetryStrategy batchWriteRetryStrategy) {
        LinkedList<FailedBatch> failedBatches = new LinkedList<FailedBatch>();
        FailedBatch failedBatch = this.doBatchWriteItemWithRetry(batch, batchWriteRetryStrategy);
        if (failedBatch != null) {
            if (failedBatch.isRequestEntityTooLarge()) {
                if (failedBatch.size() == 1) {
                    failedBatches.add(failedBatch);
                } else {
                    for (StringListMap<WriteRequest> subBatch : batch.subMaps(2, false)) {
                        failedBatches.addAll(this.writeOneBatch(subBatch, batchWriteRetryStrategy));
                    }
                }
            } else {
                failedBatches.add(failedBatch);
            }
        }
        return failedBatches;
    }

    private boolean containsThrottlingException(List<FailedBatch> failedBatches) {
        for (FailedBatch failedBatch : failedBatches) {
            if (!failedBatch.isThrottling()) continue;
            return true;
        }
        return false;
    }

    private FailedBatch doBatchWriteItemWithRetry(Map<String, List<WriteRequest>> batch, DynamoDbMapperConfig.BatchWriteRetryStrategy batchWriteRetryStrategy) {
        BatchWriteItemResponse result = null;
        int retries = 0;
        int maxRetries = batchWriteRetryStrategy.maxRetryOnUnprocessedItems(Collections.unmodifiableMap(batch));
        FailedBatch failedBatch = null;
        Map<String, List<WriteRequest>> pendingItems = batch;
        while (true) {
            try {
                result = this.db.batchWriteItem((BatchWriteItemRequest)DynamoDbMapper.applyBatchOperationUserAgent((AmazonWebServiceRequest)BatchWriteItemRequest.builder().requestItems(pendingItems).build()));
            }
            catch (Exception e) {
                failedBatch = new FailedBatch();
                failedBatch.setUnprocessedItems(pendingItems);
                failedBatch.setException(e);
                return failedBatch;
            }
            pendingItems = result.unprocessedItems();
            if (pendingItems.size() <= 0) break;
            if (maxRetries >= 0 && retries >= maxRetries) {
                failedBatch = new FailedBatch();
                failedBatch.setUnprocessedItems(pendingItems);
                failedBatch.setException(null);
                return failedBatch;
            }
            DynamoDbMapper.pause(batchWriteRetryStrategy.getDelayBeforeRetryUnprocessedItems(Collections.unmodifiableMap(pendingItems), retries));
            ++retries;
        }
        return failedBatch;
    }

    @Override
    public Map<String, List<Object>> batchLoad(Iterable<? extends Object> itemsToGet, DynamoDbMapperConfig config) {
        boolean consistentReads;
        boolean bl = consistentReads = (config = this.mergeConfig(config)).getConsistentReads() == DynamoDbMapperConfig.ConsistentReads.CONSISTENT;
        if (itemsToGet == null) {
            return new HashMap<String, List<Object>>();
        }
        HashMap<String, KeysAndAttributes> requestItems = new HashMap<String, KeysAndAttributes>();
        HashMap classesByTableName = new HashMap();
        HashMap<String, List<Object>> resultSet = new HashMap<String, List<Object>>();
        int count = 0;
        for (Object object : itemsToGet) {
            Class<?> clazz = object.getClass();
            DynamoDbMapperTableModel<?> model = this.getTableModel(clazz, config);
            String tableName = this.getTableName(clazz, object, config);
            classesByTableName.put(tableName, clazz);
            if (!requestItems.containsKey(tableName)) {
                requestItems.put(tableName, (KeysAndAttributes)KeysAndAttributes.builder().consistentRead(consistentReads).keys(new LinkedList<Map<String, AttributeValue>>()).build());
            }
            ((KeysAndAttributes)requestItems.get(tableName)).keys().add(model.convertKey(object));
            if (++count != 100) continue;
            this.processBatchGetRequest(classesByTableName, requestItems, resultSet, config);
            requestItems.clear();
            count = 0;
        }
        if (count > 0) {
            this.processBatchGetRequest(classesByTableName, requestItems, resultSet, config);
        }
        return resultSet;
    }

    @Override
    public Map<String, List<Object>> batchLoad(Map<Class<?>, List<KeyPair>> itemsToGet, DynamoDbMapperConfig config) {
        config = this.mergeConfig(config);
        ArrayList keys = new ArrayList();
        if (itemsToGet != null) {
            for (Map.Entry<Class<?>, List<KeyPair>> item : itemsToGet.entrySet()) {
                Class<?> clazz = item.getKey();
                List<KeyPair> value = item.getValue();
                if (value == null) continue;
                DynamoDbMapperTableModel<?> model = this.getTableModel(clazz, config);
                for (KeyPair keyPair : value) {
                    keys.add(model.createKey(keyPair.getHashKey(), keyPair.getRangeKey()));
                }
            }
        }
        return this.batchLoad(keys, config);
    }

    private void processBatchGetRequest(Map<String, Class<?>> classesByTableName, Map<String, KeysAndAttributes> requestItems, Map<String, List<Object>> resultSet, DynamoDbMapperConfig config) {
        BatchGetItemResponse batchGetItemResponse = null;
        BatchGetItemRequest batchGetItemRequest = (BatchGetItemRequest)((Object)BatchGetItemRequest.builder().requestItems(requestItems).build());
        DynamoDbMapperConfig.BatchLoadRetryStrategy batchLoadStrategy = config.batchLoadRetryStrategy();
        BatchLoadContext batchLoadContext = new BatchLoadContext(batchGetItemRequest);
        int retries = 0;
        do {
            if (batchGetItemResponse != null) {
                batchLoadContext.setRetriesAttempted(++retries);
                if (!DynamoDbMapper.isNullOrEmpty(batchGetItemResponse.unprocessedKeys())) {
                    DynamoDbMapper.pause(batchLoadStrategy.getDelayBeforeNextRetry(batchLoadContext));
                    batchGetItemRequest = (BatchGetItemRequest)((Object)batchGetItemRequest.toBuilder().requestItems(batchGetItemResponse.unprocessedKeys()).build());
                    batchLoadContext.setBatchGetItemRequest(batchGetItemRequest);
                }
            }
            batchGetItemResponse = this.db.batchGetItem((BatchGetItemRequest)DynamoDbMapper.applyBatchOperationUserAgent(batchGetItemRequest).withRequestMetricCollector(config.getRequestMetricCollector()));
            Map<String, List<Map<String, AttributeValue>>> responses = batchGetItemResponse.responses();
            for (Map.Entry<String, List<Map<String, AttributeValue>>> entries : responses.entrySet()) {
                String tableName = entries.getKey();
                List<Map<String, AttributeValue>> items = entries.getValue();
                List objects = resultSet.getOrDefault(tableName, new LinkedList());
                Class<?> clazz = classesByTableName.get(tableName);
                for (Map<String, AttributeValue> item : items) {
                    AttributeTransformer.Parameters<?> parameters = this.toParameters(item, clazz, tableName, config);
                    objects.add(this.privateMarshallIntoObject(parameters));
                }
                resultSet.put(tableName, objects);
            }
            batchLoadContext.setBatchGetItemResponse(batchGetItemResponse);
        } while (batchLoadStrategy.shouldRetry(batchLoadContext));
        if (!DynamoDbMapper.isNullOrEmpty(batchGetItemResponse.unprocessedKeys())) {
            throw new BatchGetItemException("The BatchGetItemResponse has unprocessed keys after max retry attempts. Catch the BatchGetItemException to get the list of unprocessed keys.", batchGetItemResponse.unprocessedKeys(), resultSet);
        }
    }

    @Override
    public <T> PaginatedScanList<T> scan(Class<T> clazz, DynamoDbScanExpression scanExpression, DynamoDbMapperConfig config) {
        config = this.mergeConfig(config);
        ScanRequest scanRequest = this.createScanRequestFromExpression(clazz, scanExpression, config);
        ScanResponse scanResult = this.db.scan(DynamoDbMapper.applyUserAgent(scanRequest));
        return new PaginatedScanList<T>(this, clazz, this.db, scanRequest, scanResult, config.getPaginationLoadingStrategy(), config);
    }

    @Override
    public <T> PaginatedParallelScanList<T> parallelScan(Class<T> clazz, DynamoDbScanExpression scanExpression, int totalSegments, DynamoDbMapperConfig config) {
        config = this.mergeConfig(config);
        List<ScanRequest> parallelScanRequests = this.createParallelScanRequestsFromExpression(clazz, scanExpression, totalSegments, config);
        ParallelScanTask parallelScanTask = new ParallelScanTask(this.db, parallelScanRequests);
        return new PaginatedParallelScanList<T>(this, clazz, this.db, parallelScanTask, config.getPaginationLoadingStrategy(), config);
    }

    @Override
    public <T> ScanResultPage<T> scanPage(Class<T> clazz, DynamoDbScanExpression scanExpression, DynamoDbMapperConfig config) {
        config = this.mergeConfig(config);
        ScanRequest scanRequest = this.createScanRequestFromExpression(clazz, scanExpression, config);
        ScanResponse scanResult = this.db.scan(DynamoDbMapper.applyUserAgent(scanRequest));
        ScanResultPage<T> result = new ScanResultPage<T>();
        List<AttributeTransformer.Parameters<T>> parameters = this.toParameters(scanResult.items(), clazz, scanRequest.tableName(), config);
        result.setResults(this.marshallIntoObjects(parameters));
        result.setLastEvaluatedKey(scanResult.lastEvaluatedKey());
        result.setCount(scanResult.count());
        result.setScannedCount(scanResult.scannedCount());
        result.setConsumedCapacity(scanResult.consumedCapacity());
        return result;
    }

    @Override
    public <T> PaginatedQueryList<T> query(Class<T> clazz, DynamoDbQueryExpression<T> queryExpression, DynamoDbMapperConfig config) {
        config = this.mergeConfig(config);
        QueryRequest queryRequest = this.createQueryRequestFromExpression(clazz, queryExpression, config);
        QueryResponse queryResult = this.db.query(DynamoDbMapper.applyUserAgent(queryRequest));
        return new PaginatedQueryList<T>(this, clazz, this.db, queryRequest, queryResult, config.getPaginationLoadingStrategy(), config);
    }

    @Override
    public <T> QueryResultPage<T> queryPage(Class<T> clazz, DynamoDbQueryExpression<T> queryExpression, DynamoDbMapperConfig config) {
        config = this.mergeConfig(config);
        QueryRequest queryRequest = this.createQueryRequestFromExpression(clazz, queryExpression, config);
        QueryResponse queryResult = this.db.query(DynamoDbMapper.applyUserAgent(queryRequest));
        QueryResultPage<T> result = new QueryResultPage<T>();
        List<AttributeTransformer.Parameters<T>> parameters = this.toParameters(queryResult.items(), clazz, queryRequest.tableName(), config);
        result.setResults(this.marshallIntoObjects(parameters));
        result.setLastEvaluatedKey(queryResult.lastEvaluatedKey());
        result.setCount(queryResult.count());
        result.setScannedCount(queryResult.scannedCount());
        result.setConsumedCapacity(queryResult.consumedCapacity());
        return result;
    }

    @Override
    public int count(Class<?> clazz, DynamoDbScanExpression scanExpression, DynamoDbMapperConfig config) {
        ScanResponse scanResult;
        config = this.mergeConfig(config);
        ScanRequest scanRequest = this.createScanRequestFromExpression(clazz, scanExpression, config);
        scanRequest = (ScanRequest)((Object)scanRequest.toBuilder().select(Select.COUNT).build());
        int count = 0;
        do {
            scanResult = this.db.scan(DynamoDbMapper.applyUserAgent(scanRequest));
            count += scanResult.count().intValue();
            scanRequest = (ScanRequest)((Object)scanRequest.toBuilder().exclusiveStartKey(scanResult.lastEvaluatedKey()).build());
        } while (scanResult.lastEvaluatedKey() != null);
        return count;
    }

    @Override
    public <T> int count(Class<T> clazz, DynamoDbQueryExpression<T> queryExpression, DynamoDbMapperConfig config) {
        QueryResponse queryResult;
        config = this.mergeConfig(config);
        QueryRequest queryRequest = this.createQueryRequestFromExpression(clazz, queryExpression, config);
        queryRequest = (QueryRequest)((Object)queryRequest.toBuilder().select(Select.COUNT).build());
        int count = 0;
        do {
            queryResult = this.db.query(DynamoDbMapper.applyUserAgent(queryRequest));
            count += queryResult.count().intValue();
            queryRequest = (QueryRequest)((Object)queryRequest.toBuilder().exclusiveStartKey(queryResult.lastEvaluatedKey()).build());
        } while (queryResult.lastEvaluatedKey() != null);
        return count;
    }

    private ScanRequest createScanRequestFromExpression(Class<?> clazz, DynamoDbScanExpression scanExpression, DynamoDbMapperConfig config) {
        ScanRequest scanRequest = (ScanRequest)((Object)ScanRequest.builder().tableName(this.getTableName(clazz, config)).indexName(scanExpression.getIndexName()).scanFilter(scanExpression.scanFilter()).limit(scanExpression.limit()).exclusiveStartKey(scanExpression.getExclusiveStartKey()).totalSegments(scanExpression.getTotalSegments()).segment(scanExpression.segment()).conditionalOperator(scanExpression.getConditionalOperator()).filterExpression(scanExpression.getFilterExpression()).expressionAttributeNames(scanExpression.getExpressionAttributeNames()).expressionAttributeValues(scanExpression.getExpressionAttributeValues()).select(scanExpression.select()).projectionExpression(scanExpression.getProjectionExpression()).returnConsumedCapacity(scanExpression.getReturnConsumedCapacity()).consistentRead(scanExpression.isConsistentRead()).build());
        return (ScanRequest)DynamoDbMapper.applyUserAgent(scanRequest.withRequestMetricCollector(config.getRequestMetricCollector()));
    }

    private List<ScanRequest> createParallelScanRequestsFromExpression(Class<?> clazz, DynamoDbScanExpression scanExpression, int totalSegments, DynamoDbMapperConfig config) {
        if (totalSegments < 1) {
            throw new IllegalArgumentException("Parallel scan should have at least one scan segment.");
        }
        if (scanExpression.getExclusiveStartKey() != null) {
            log.info((Object)"The ExclusiveStartKey parameter specified in the DynamoDBScanExpression is ignored, since the individual parallel scan request on each segment is applied on a separate key scope.");
        }
        if (scanExpression.segment() != null || scanExpression.getTotalSegments() != null) {
            log.info((Object)"The Segment and TotalSegments parameters specified in the DynamoDBScanExpression are ignored.");
        }
        LinkedList<ScanRequest> parallelScanRequests = new LinkedList<ScanRequest>();
        for (int segment = 0; segment < totalSegments; ++segment) {
            ScanRequest scanRequest = (ScanRequest)((Object)this.createScanRequestFromExpression(clazz, scanExpression, config).toBuilder().segment(segment).totalSegments(totalSegments).exclusiveStartKey(null).build());
            parallelScanRequests.add(scanRequest);
        }
        return parallelScanRequests;
    }

    private <T> QueryRequest createQueryRequestFromExpression(Class<T> clazz, DynamoDbQueryExpression<T> xpress, DynamoDbMapperConfig config) {
        DynamoDbMapperTableModel<T> model = this.getTableModel(clazz, config);
        QueryRequest request = (QueryRequest)((Object)QueryRequest.builder().consistentRead(xpress.isConsistentRead()).tableName(this.getTableName(clazz, xpress.getHashKeyValues(), config)).indexName(xpress.getIndexName()).keyConditionExpression(xpress.getKeyConditionExpression()).build());
        request = DynamoDbMapper.processKeyConditions(request, xpress, model);
        request = (QueryRequest)((Object)request.toBuilder().scanIndexForward(xpress.isScanIndexForward()).limit(xpress.limit()).exclusiveStartKey(xpress.getExclusiveStartKey()).queryFilter(xpress.getQueryFilter()).conditionalOperator(xpress.getConditionalOperator()).select(xpress.select()).projectionExpression(xpress.getProjectionExpression()).filterExpression(xpress.getFilterExpression()).expressionAttributeNames(xpress.getExpressionAttributeNames()).expressionAttributeValues(xpress.getExpressionAttributeValues()).returnConsumedCapacity(xpress.getReturnConsumedCapacity()).build());
        return (QueryRequest)DynamoDbMapper.applyUserAgent(request.withRequestMetricCollector(config.getRequestMetricCollector()));
    }

    private <T> AttributeTransformer.Parameters<T> toParameters(Map<String, AttributeValue> attributeValues, Class<T> modelClass, String tableName, DynamoDbMapperConfig mapperConfig) {
        return this.toParameters(attributeValues, false, modelClass, tableName, mapperConfig);
    }

    private <T> AttributeTransformer.Parameters<T> toParameters(Map<String, AttributeValue> attributeValues, boolean partialUpdate, Class<T> modelClass, String tableName, DynamoDbMapperConfig mapperConfig) {
        return new TransformerParameters<T>(this.getTableModel(modelClass, mapperConfig), attributeValues, partialUpdate, modelClass, mapperConfig, tableName);
    }

    final <T> List<AttributeTransformer.Parameters<T>> toParameters(List<Map<String, AttributeValue>> attributeValues, Class<T> modelClass, String tableName, DynamoDbMapperConfig mapperConfig) {
        ArrayList<AttributeTransformer.Parameters<T>> rval = new ArrayList<AttributeTransformer.Parameters<T>>(attributeValues.size());
        for (Map<String, AttributeValue> item : attributeValues) {
            rval.add(this.toParameters(item, modelClass, tableName, mapperConfig));
        }
        return rval;
    }

    private Map<String, AttributeValue> untransformAttributes(AttributeTransformer.Parameters<?> parameters) {
        if (this.transformer != null) {
            return this.transformer.untransform(parameters);
        }
        return parameters.getAttributeValues();
    }

    private Map<String, AttributeValue> transformAttributes(AttributeTransformer.Parameters<?> parameters) {
        if (this.transformer != null) {
            return this.transformer.transform(parameters);
        }
        return parameters.getAttributeValues();
    }

    @Override
    public S3ClientCache s3ClientCache() {
        return this.s3Links.s3ClientCache();
    }

    @Override
    public S3Link createS3Link(Region s3region, String bucketName, String key) {
        return this.s3Links.createS3Link(s3region, bucketName, key);
    }

    @Override
    public S3Link createS3Link(String s3region, String bucketName, String key) {
        return this.s3Links.createS3Link(s3region, bucketName, key);
    }

    @Override
    public <T> CreateTableRequest generateCreateTableRequest(Class<T> clazz, DynamoDbMapperConfig config) {
        config = this.mergeConfig(config);
        DynamoDbMapperTableModel<T> model = this.getTableModel(clazz, config);
        CreateTableRequest.Builder requestBuilder = CreateTableRequest.builder().tableName(this.getTableName(clazz, config)).keySchema((KeySchemaElement)KeySchemaElement.builder().attributeName(model.hashKey().name()).keyType(KeyType.HASH).build());
        if (model.rangeKeyIfExists() != null) {
            requestBuilder.keySchema((KeySchemaElement)KeySchemaElement.builder().attributeName(model.rangeKey().name()).keyType(KeyType.RANGE).build());
        }
        requestBuilder.globalSecondaryIndexes(model.globalSecondaryIndexes()).localSecondaryIndexes(model.localSecondaryIndexes());
        for (DynamoDbMapperFieldModel<T, Object> field : model.fields()) {
            if (field.keyType() == null && !field.indexed()) continue;
            AttributeDefinition attributeDefinition = (AttributeDefinition)AttributeDefinition.builder().attributeType(ScalarAttributeType.valueOf(field.attributeType().name())).attributeName(field.name()).build();
            requestBuilder.attributeDefinitions(attributeDefinition);
        }
        return (CreateTableRequest)((Object)requestBuilder.build());
    }

    @Override
    public <T> DeleteTableRequest generateDeleteTableRequest(Class<T> clazz, DynamoDbMapperConfig config) {
        config = this.mergeConfig(config);
        DeleteTableRequest deleteTableRequest = (DeleteTableRequest)((Object)DeleteTableRequest.builder().tableName(this.getTableName(clazz, config)).build());
        return deleteTableRequest;
    }

    public <T, H, R> DynamoDbTableMapper<T, H, R> newTableMapper(Class<T> clazz) {
        DynamoDbMapperConfig config = this.mergeConfig(null);
        return new DynamoDbTableMapper(this.db, this, config, this.getTableModel(clazz, config));
    }

    private static final class ValueUpdate {
        private final DynamoDbMapperFieldModel<Object, Object> field;
        private final AttributeValue newValue;
        private final Object target;

        public ValueUpdate(DynamoDbMapperFieldModel<Object, Object> field, AttributeValue newValue, Object target) {
            this.field = field;
            this.newValue = newValue;
            this.target = target;
        }

        public void apply() {
            this.field.set(this.target, this.field.unconvert(this.newValue));
        }
    }

    protected abstract class SaveObjectHandler {
        protected final Object object;
        protected final Class<?> clazz;
        protected final Map<String, ExpectedAttributeValue> userProvidedExpectedValueConditions;
        protected final String userProvidedConditionOperator;
        private final String tableName;
        private final DynamoDbMapperConfig saveConfig;
        private final Map<String, AttributeValue> primaryKeys;
        private final Map<String, AttributeValueUpdate> updateValues;
        private final Map<String, ExpectedAttributeValue> internalExpectedValueAssertions;
        private final List<ValueUpdate> inMemoryUpdates;

        public SaveObjectHandler(Class<?> clazz, Object object, String tableName, DynamoDbMapperConfig saveConfig, DynamoDbSaveExpression saveExpression) {
            this.clazz = clazz;
            this.object = object;
            this.tableName = tableName;
            this.saveConfig = saveConfig;
            if (saveExpression != null) {
                this.userProvidedExpectedValueConditions = saveExpression.getExpected();
                this.userProvidedConditionOperator = saveExpression.getConditionalOperator();
            } else {
                this.userProvidedExpectedValueConditions = null;
                this.userProvidedConditionOperator = null;
            }
            this.updateValues = new HashMap<String, AttributeValueUpdate>();
            this.internalExpectedValueAssertions = new HashMap<String, ExpectedAttributeValue>();
            this.inMemoryUpdates = new LinkedList<ValueUpdate>();
            this.primaryKeys = new HashMap<String, AttributeValue>();
        }

        public void execute() {
            DynamoDbMapperTableModel<?> model = DynamoDbMapper.this.getTableModel(this.clazz, this.saveConfig);
            for (DynamoDbMapperFieldModel<Object, Object> dynamoDbMapperFieldModel : model.fields()) {
                if (DynamoDbMapper.canGenerate(model, this.object, this.localSaveBehavior(), dynamoDbMapperFieldModel)) {
                    if (dynamoDbMapperFieldModel.keyType() != null || dynamoDbMapperFieldModel.indexed()) {
                        this.onAutoGenerateAssignableKey(dynamoDbMapperFieldModel);
                        continue;
                    }
                    if (dynamoDbMapperFieldModel.versioned()) {
                        this.onVersionAttribute(dynamoDbMapperFieldModel);
                        continue;
                    }
                    this.onAutoGenerate(dynamoDbMapperFieldModel);
                    continue;
                }
                if (dynamoDbMapperFieldModel.keyType() != null) {
                    Object newAttributeValue = dynamoDbMapperFieldModel.convert(dynamoDbMapperFieldModel.get(this.object));
                    if (newAttributeValue == null) {
                        throw new DynamoDbMappingException(this.clazz.getSimpleName() + "[" + dynamoDbMapperFieldModel.name() + "]; null or empty value for primary key");
                    }
                    this.onPrimaryKeyAttributeValue(dynamoDbMapperFieldModel.name(), (AttributeValue)newAttributeValue);
                    continue;
                }
                Object currentValue = dynamoDbMapperFieldModel.convert(dynamoDbMapperFieldModel.get(this.object));
                if (currentValue != null) {
                    this.onNonKeyAttribute(dynamoDbMapperFieldModel.name(), (AttributeValue)currentValue);
                    continue;
                }
                this.onNullNonKeyAttribute(dynamoDbMapperFieldModel.name());
            }
            this.executeLowLevelRequest();
            for (ValueUpdate valueUpdate : this.inMemoryUpdates) {
                valueUpdate.apply();
            }
        }

        protected abstract void onPrimaryKeyAttributeValue(String var1, AttributeValue var2);

        protected void onNonKeyAttribute(String attributeName, AttributeValue currentValue) {
            this.updateValues.put(attributeName, (AttributeValueUpdate)AttributeValueUpdate.builder().value(currentValue).action("PUT").build());
        }

        protected abstract void onNullNonKeyAttribute(String var1);

        protected abstract void executeLowLevelRequest();

        protected DynamoDbMapperConfig.SaveBehavior localSaveBehavior() {
            return this.saveConfig.saveBehavior();
        }

        protected String getTableName() {
            return this.tableName;
        }

        protected Map<String, AttributeValue> getPrimaryKeyAttributeValues() {
            return this.primaryKeys;
        }

        protected Map<String, AttributeValueUpdate> getAttributeValueUpdates() {
            return this.updateValues;
        }

        protected Map<String, ExpectedAttributeValue> mergeExpectedAttributeValueConditions() {
            return DynamoDbMapper.mergeExpectedAttributeValueConditions(this.internalExpectedValueAssertions, this.userProvidedExpectedValueConditions, this.userProvidedConditionOperator);
        }

        protected List<ValueUpdate> getInMemoryUpdates() {
            return this.inMemoryUpdates;
        }

        protected UpdateItemResponse doUpdateItem() {
            UpdateItemRequest req = (UpdateItemRequest)((Object)UpdateItemRequest.builder().tableName(this.getTableName()).key(this.getPrimaryKeyAttributeValues()).attributeUpdates(this.transformAttributeUpdates(this.clazz, this.getTableName(), this.getPrimaryKeyAttributeValues(), this.getAttributeValueUpdates(), this.saveConfig)).expected(this.mergeExpectedAttributeValueConditions()).conditionalOperator(this.userProvidedConditionOperator).returnValues(ReturnValue.ALL_NEW).build());
            return DynamoDbMapper.this.db.updateItem((UpdateItemRequest)DynamoDbMapper.applyUserAgent(req.withRequestMetricCollector(this.saveConfig.getRequestMetricCollector())));
        }

        protected PutItemResponse doPutItem() {
            Map attributeValues = this.convertToItem(this.getAttributeValueUpdates());
            attributeValues = DynamoDbMapper.this.transformAttributes(DynamoDbMapper.this.toParameters(attributeValues, this.clazz, this.getTableName(), this.saveConfig));
            PutItemRequest req = (PutItemRequest)((Object)PutItemRequest.builder().tableName(this.getTableName()).item(attributeValues).expected(this.mergeExpectedAttributeValueConditions()).conditionalOperator(this.userProvidedConditionOperator).build());
            return DynamoDbMapper.this.db.putItem((PutItemRequest)DynamoDbMapper.applyUserAgent(req.withRequestMetricCollector(this.saveConfig.getRequestMetricCollector())));
        }

        private void onAutoGenerate(DynamoDbMapperFieldModel<Object, Object> field) {
            Object value = field.convert(field.generate(field.get(this.object)));
            this.updateValues.put(field.name(), (AttributeValueUpdate)AttributeValueUpdate.builder().action("PUT").value((AttributeValue)value).build());
            this.inMemoryUpdates.add(new ValueUpdate(field, (AttributeValue)value, this.object));
        }

        private void onAutoGenerateAssignableKey(DynamoDbMapperFieldModel<Object, Object> field) {
            this.onAutoGenerate(field);
            if (this.localSaveBehavior() != DynamoDbMapperConfig.SaveBehavior.CLOBBER && !this.internalExpectedValueAssertions.containsKey(field.name()) && field.getGenerateStrategy() != DynamoDbAutoGenerateStrategy.ALWAYS) {
                this.internalExpectedValueAssertions.put(field.name(), (ExpectedAttributeValue)ExpectedAttributeValue.builder().exists(false).build());
            }
        }

        private void onVersionAttribute(DynamoDbMapperFieldModel<Object, Object> field) {
            if (this.localSaveBehavior() != DynamoDbMapperConfig.SaveBehavior.CLOBBER && !this.internalExpectedValueAssertions.containsKey(field.name())) {
                Object current = field.get(this.object);
                if (current == null) {
                    this.internalExpectedValueAssertions.put(field.name(), (ExpectedAttributeValue)ExpectedAttributeValue.builder().exists(false).build());
                } else {
                    this.internalExpectedValueAssertions.put(field.name(), (ExpectedAttributeValue)ExpectedAttributeValue.builder().exists(true).value((AttributeValue)field.convert(current)).build());
                }
            }
            this.onAutoGenerate(field);
        }

        private Map<String, AttributeValue> convertToItem(Map<String, AttributeValueUpdate> putValues) {
            HashMap<String, AttributeValue> map = new HashMap<String, AttributeValue>();
            for (Map.Entry<String, AttributeValueUpdate> entry : putValues.entrySet()) {
                String attributeName = entry.getKey();
                AttributeValue attributeValue = entry.getValue().value();
                String attributeAction = entry.getValue().action();
                if (attributeValue == null || AttributeAction.DELETE.toString().equals(attributeAction)) continue;
                map.put(attributeName, attributeValue);
            }
            return map;
        }

        private Map<String, AttributeValueUpdate> transformAttributeUpdates(Class<?> clazz, String tableName, Map<String, AttributeValue> keys, Map<String, AttributeValueUpdate> updateValues, DynamoDbMapperConfig config) {
            Map item = this.convertToItem(updateValues);
            HashSet<String> keysAdded = new HashSet<String>();
            for (Map.Entry<String, AttributeValue> e : keys.entrySet()) {
                if (item.containsKey(e.getKey())) continue;
                keysAdded.add(e.getKey());
                item.put((String)e.getKey(), (AttributeValue)e.getValue());
            }
            AttributeTransformer.Parameters parameters = DynamoDbMapper.this.toParameters(item, true, clazz, tableName, config);
            String hashKey = parameters.getHashKeyName();
            if (!item.containsKey(hashKey)) {
                item.put(hashKey, keys.get(hashKey));
            }
            item = DynamoDbMapper.this.transformAttributes(parameters);
            for (Map.Entry entry : item.entrySet()) {
                if (keysAdded.contains(entry.getKey())) continue;
                AttributeValueUpdate update = updateValues.get(entry.getKey());
                if (update != null) {
                    AttributeValue value = (AttributeValue)update.value().toBuilder().b(((AttributeValue)entry.getValue()).b()).bs(((AttributeValue)entry.getValue()).bs()).n(((AttributeValue)entry.getValue()).n()).ns(((AttributeValue)entry.getValue()).ns()).s(((AttributeValue)entry.getValue()).s()).ss(((AttributeValue)entry.getValue()).ss()).m(((AttributeValue)entry.getValue()).m()).l(((AttributeValue)entry.getValue()).l()).nul(((AttributeValue)entry.getValue()).nul()).bool(((AttributeValue)entry.getValue()).bool()).build();
                    update = (AttributeValueUpdate)update.toBuilder().value(value).build();
                    updateValues.put((String)entry.getKey(), update);
                    continue;
                }
                updateValues.put((String)entry.getKey(), (AttributeValueUpdate)AttributeValueUpdate.builder().value((AttributeValue)entry.getValue()).action("PUT").build());
            }
            return updateValues;
        }
    }

    public static final class BatchGetItemException
    extends SdkClientException {
        private transient Map<String, KeysAndAttributes> unprocessedKeys;
        private transient Map<String, List<Object>> responses;

        public BatchGetItemException(String message, Map<String, KeysAndAttributes> unprocessedKeys, Map<String, List<Object>> responses) {
            super(message);
            this.unprocessedKeys = unprocessedKeys;
            this.responses = responses;
        }

        public Map<String, KeysAndAttributes> getUnprocessedKeys() {
            return this.unprocessedKeys;
        }

        public Map<String, List<Object>> getResponses() {
            return this.responses;
        }
    }

    static final class StringListMap<T>
    extends LinkedHashMap<String, List<T>> {
        private static final long serialVersionUID = -1L;

        StringListMap() {
        }

        public List<T> getPutIfNotExists(String key) {
            LinkedList list = (LinkedList)this.get(key);
            if (list == null) {
                list = new LinkedList();
                this.put(key, list);
            }
            return list;
        }

        public boolean add(String key, T value) {
            return this.getPutIfNotExists(key).add(value);
        }

        public List<StringListMap<T>> subMaps(int size, boolean perMap) {
            LinkedList<StringListMap<T>> maps = new LinkedList<StringListMap<T>>();
            int index = 0;
            int count = 0;
            for (Map.Entry entry : this.entrySet()) {
                for (Object value : (List)entry.getValue()) {
                    if (index == maps.size()) {
                        maps.add(new StringListMap<T>());
                    }
                    maps.get(index).add((String)entry.getKey(), value);
                    index = perMap ? ++count / size : ++index % size;
                }
            }
            return maps;
        }
    }

    public static class FailedBatch {
        private Map<String, List<WriteRequest>> unprocessedItems;
        private Exception exception;

        public Map<String, List<WriteRequest>> getUnprocessedItems() {
            return this.unprocessedItems;
        }

        public void setUnprocessedItems(Map<String, List<WriteRequest>> unprocessedItems) {
            this.unprocessedItems = unprocessedItems;
        }

        public Exception getException() {
            return this.exception;
        }

        public void setException(Exception excetpion) {
            this.exception = excetpion;
        }

        private final boolean isRequestEntityTooLarge() {
            return this.exception instanceof AmazonServiceException && RetryUtils.isRequestEntityTooLargeException((SdkBaseException)((AmazonServiceException)this.exception));
        }

        private final boolean isThrottling() {
            return this.exception instanceof AmazonServiceException && RetryUtils.isThrottlingException((AmazonServiceException)((AmazonServiceException)this.exception));
        }

        private final int size() {
            int size = 0;
            for (List<WriteRequest> values : this.unprocessedItems.values()) {
                size += values.size();
            }
            return size;
        }
    }

    private static class TransformerParameters<T>
    implements AttributeTransformer.Parameters<T> {
        private final DynamoDbMapperTableModel<T> model;
        private final Map<String, AttributeValue> attributeValues;
        private final boolean partialUpdate;
        private final Class<T> modelClass;
        private final DynamoDbMapperConfig mapperConfig;
        private final String tableName;

        public TransformerParameters(DynamoDbMapperTableModel<T> model, Map<String, AttributeValue> attributeValues, boolean partialUpdate, Class<T> modelClass, DynamoDbMapperConfig mapperConfig, String tableName) {
            this.model = model;
            this.attributeValues = Collections.unmodifiableMap(attributeValues);
            this.partialUpdate = partialUpdate;
            this.modelClass = modelClass;
            this.mapperConfig = mapperConfig;
            this.tableName = tableName;
        }

        @Override
        public Map<String, AttributeValue> getAttributeValues() {
            return this.attributeValues;
        }

        @Override
        public boolean isPartialUpdate() {
            return this.partialUpdate;
        }

        @Override
        public Class<T> modelClass() {
            return this.modelClass;
        }

        @Override
        public DynamoDbMapperConfig mapperConfig() {
            return this.mapperConfig;
        }

        @Override
        public String getTableName() {
            return this.tableName;
        }

        @Override
        public String getHashKeyName() {
            return this.model.hashKey().name();
        }

        @Override
        public String getRangeKeyName() {
            return this.model.rangeKeyIfExists() == null ? null : this.model.rangeKey().name();
        }
    }
}

