/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb;

import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.client.AsyncClientHandler;
import software.amazon.awssdk.client.AwsAsyncClientParams;
import software.amazon.awssdk.client.AwsSyncClientParams;
import software.amazon.awssdk.client.ClientExecutionParams;
import software.amazon.awssdk.client.ClientHandlerParams;
import software.amazon.awssdk.client.SdkAsyncClientHandler;
import software.amazon.awssdk.http.HttpResponseHandler;
import software.amazon.awssdk.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.runtime.http.response.JsonResponseHandler;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.dynamodb.DynamoDBAsyncClient;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemResponse;
import software.amazon.awssdk.services.dynamodb.model.ConditionalCheckFailedException;
import software.amazon.awssdk.services.dynamodb.model.CreateTableRequest;
import software.amazon.awssdk.services.dynamodb.model.CreateTableResponse;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemResponse;
import software.amazon.awssdk.services.dynamodb.model.DeleteTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteTableResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeLimitsRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeLimitsResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeTimeToLiveRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTimeToLiveResponse;
import software.amazon.awssdk.services.dynamodb.model.DynamoDBException;
import software.amazon.awssdk.services.dynamodb.model.GetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.GetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.InternalServerErrorException;
import software.amazon.awssdk.services.dynamodb.model.ItemCollectionSizeLimitExceededException;
import software.amazon.awssdk.services.dynamodb.model.LimitExceededException;
import software.amazon.awssdk.services.dynamodb.model.ListTablesRequest;
import software.amazon.awssdk.services.dynamodb.model.ListTablesResponse;
import software.amazon.awssdk.services.dynamodb.model.ListTagsOfResourceRequest;
import software.amazon.awssdk.services.dynamodb.model.ListTagsOfResourceResponse;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughputExceededException;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;
import software.amazon.awssdk.services.dynamodb.model.PutItemResponse;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryResponse;
import software.amazon.awssdk.services.dynamodb.model.ResourceInUseException;
import software.amazon.awssdk.services.dynamodb.model.ResourceNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.model.ScanResponse;
import software.amazon.awssdk.services.dynamodb.model.TagResourceRequest;
import software.amazon.awssdk.services.dynamodb.model.TagResourceResponse;
import software.amazon.awssdk.services.dynamodb.model.UntagResourceRequest;
import software.amazon.awssdk.services.dynamodb.model.UntagResourceResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateTableRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateTableResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateTimeToLiveRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateTimeToLiveResponse;
import software.amazon.awssdk.services.dynamodb.transform.BatchGetItemRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.BatchGetItemResponseUnmarshaller;
import software.amazon.awssdk.services.dynamodb.transform.BatchWriteItemRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.BatchWriteItemResponseUnmarshaller;
import software.amazon.awssdk.services.dynamodb.transform.CreateTableRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.CreateTableResponseUnmarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DeleteItemRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DeleteItemResponseUnmarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DeleteTableRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DeleteTableResponseUnmarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DescribeLimitsRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DescribeLimitsResponseUnmarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DescribeTableRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DescribeTableResponseUnmarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DescribeTimeToLiveRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DescribeTimeToLiveResponseUnmarshaller;
import software.amazon.awssdk.services.dynamodb.transform.GetItemRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.GetItemResponseUnmarshaller;
import software.amazon.awssdk.services.dynamodb.transform.ListTablesRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.ListTablesResponseUnmarshaller;
import software.amazon.awssdk.services.dynamodb.transform.ListTagsOfResourceRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.ListTagsOfResourceResponseUnmarshaller;
import software.amazon.awssdk.services.dynamodb.transform.PutItemRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.PutItemResponseUnmarshaller;
import software.amazon.awssdk.services.dynamodb.transform.QueryRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.QueryResponseUnmarshaller;
import software.amazon.awssdk.services.dynamodb.transform.ScanRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.ScanResponseUnmarshaller;
import software.amazon.awssdk.services.dynamodb.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.TagResourceResponseUnmarshaller;
import software.amazon.awssdk.services.dynamodb.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.UntagResourceResponseUnmarshaller;
import software.amazon.awssdk.services.dynamodb.transform.UpdateItemRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.UpdateItemResponseUnmarshaller;
import software.amazon.awssdk.services.dynamodb.transform.UpdateTableRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.UpdateTableResponseUnmarshaller;
import software.amazon.awssdk.services.dynamodb.transform.UpdateTimeToLiveRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.UpdateTimeToLiveResponseUnmarshaller;

@SdkInternalApi
final class DefaultDynamoDBAsyncClient
implements DynamoDBAsyncClient {
    private final AsyncClientHandler clientHandler;
    private final SdkJsonProtocolFactory protocolFactory;

    protected DefaultDynamoDBAsyncClient(AwsAsyncClientParams clientParams) {
        this.clientHandler = new SdkAsyncClientHandler(new ClientHandlerParams().withAsyncClientParams(clientParams).withClientParams((AwsSyncClientParams)clientParams).withCalculateCrc32FromCompressedDataEnabled(true));
        this.protocolFactory = this.init();
    }

    @Override
    public CompletableFuture<BatchGetItemResponse> batchGetItem(BatchGetItemRequest batchGetItemRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new BatchGetItemResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new BatchGetItemRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)batchGetItemRequest));
    }

    @Override
    public CompletableFuture<BatchWriteItemResponse> batchWriteItem(BatchWriteItemRequest batchWriteItemRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new BatchWriteItemResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new BatchWriteItemRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)batchWriteItemRequest));
    }

    @Override
    public CompletableFuture<CreateTableResponse> createTable(CreateTableRequest createTableRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new CreateTableResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreateTableRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)createTableRequest));
    }

    @Override
    public CompletableFuture<DeleteItemResponse> deleteItem(DeleteItemRequest deleteItemRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DeleteItemResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteItemRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)deleteItemRequest));
    }

    @Override
    public CompletableFuture<DeleteTableResponse> deleteTable(DeleteTableRequest deleteTableRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DeleteTableResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteTableRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)deleteTableRequest));
    }

    @Override
    public CompletableFuture<DescribeLimitsResponse> describeLimits(DescribeLimitsRequest describeLimitsRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DescribeLimitsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeLimitsRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)describeLimitsRequest));
    }

    @Override
    public CompletableFuture<DescribeTableResponse> describeTable(DescribeTableRequest describeTableRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DescribeTableResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeTableRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)describeTableRequest));
    }

    @Override
    public CompletableFuture<DescribeTimeToLiveResponse> describeTimeToLive(DescribeTimeToLiveRequest describeTimeToLiveRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new DescribeTimeToLiveResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DescribeTimeToLiveRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)describeTimeToLiveRequest));
    }

    @Override
    public CompletableFuture<GetItemResponse> getItem(GetItemRequest getItemRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new GetItemResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new GetItemRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)getItemRequest));
    }

    @Override
    public CompletableFuture<ListTablesResponse> listTables(ListTablesRequest listTablesRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new ListTablesResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ListTablesRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)listTablesRequest));
    }

    @Override
    public CompletableFuture<ListTagsOfResourceResponse> listTagsOfResource(ListTagsOfResourceRequest listTagsOfResourceRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new ListTagsOfResourceResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ListTagsOfResourceRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)listTagsOfResourceRequest));
    }

    @Override
    public CompletableFuture<PutItemResponse> putItem(PutItemRequest putItemRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new PutItemResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new PutItemRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)putItemRequest));
    }

    @Override
    public CompletableFuture<QueryResponse> query(QueryRequest queryRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new QueryResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new QueryRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)queryRequest));
    }

    @Override
    public CompletableFuture<ScanResponse> scan(ScanRequest scanRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new ScanResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ScanRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)scanRequest));
    }

    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new TagResourceResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new TagResourceRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)tagResourceRequest));
    }

    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new UntagResourceResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new UntagResourceRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)untagResourceRequest));
    }

    @Override
    public CompletableFuture<UpdateItemResponse> updateItem(UpdateItemRequest updateItemRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new UpdateItemResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new UpdateItemRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)updateItemRequest));
    }

    @Override
    public CompletableFuture<UpdateTableResponse> updateTable(UpdateTableRequest updateTableRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new UpdateTableResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new UpdateTableRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)updateTableRequest));
    }

    @Override
    public CompletableFuture<UpdateTimeToLiveResponse> updateTimeToLive(UpdateTimeToLiveRequest updateTimeToLiveRequest) {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true), (Unmarshaller)new UpdateTimeToLiveResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new UpdateTimeToLiveRequestMarshaller(this.protocolFactory)).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((Object)updateTimeToLiveRequest));
    }

    @Override
    public void close() throws Exception {
        this.clientHandler.close();
    }

    private SdkJsonProtocolFactory init() {
        return new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.0").withSupportsCbor(false).withSupportsIon(false).withBaseServiceExceptionClass(DynamoDBException.class).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ItemCollectionSizeLimitExceededException").withModeledClass(ItemCollectionSizeLimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceInUseException").withModeledClass(ResourceInUseException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withModeledClass(ResourceNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ProvisionedThroughputExceededException").withModeledClass(ProvisionedThroughputExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConditionalCheckFailedException").withModeledClass(ConditionalCheckFailedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerError").withModeledClass(InternalServerErrorException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withModeledClass(LimitExceededException.class)));
    }

    private HttpResponseHandler<AmazonServiceException> createErrorResponseHandler() {
        return this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }
}

