/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.operations;

import java.util.Map;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.Expression;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.IndexOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.MapperExtension;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.OperationContext;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.Page;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TableMetadata;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TableOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.TableSchema;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.core.TransformIterable;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.core.Utils;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.model.ScanResponse;
import software.amazon.awssdk.services.dynamodb.paginators.ScanIterable;

@SdkPublicApi
public class Scan<T>
implements TableOperation<T, ScanRequest, ScanIterable, Iterable<Page<T>>>,
IndexOperation<T, ScanRequest, ScanIterable, Iterable<Page<T>>> {
    private final Map<String, AttributeValue> exclusiveStartKey;
    private final Integer limit;
    private final Boolean consistentRead;
    private final Expression filterExpression;

    private Scan(Map<String, AttributeValue> exclusiveStartKey, Integer limit, Boolean consistentRead, Expression filterExpression) {
        this.exclusiveStartKey = exclusiveStartKey;
        this.limit = limit;
        this.consistentRead = consistentRead;
        this.filterExpression = filterExpression;
    }

    public static <T> Scan<T> create() {
        return new Scan<T>(null, null, null, null);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().exclusiveStartKey(this.exclusiveStartKey).limit(this.limit).consistentRead(this.consistentRead).filterExpression(this.filterExpression);
    }

    @Override
    public ScanRequest generateRequest(TableSchema<T> tableSchema, OperationContext operationContext, MapperExtension mapperExtension) {
        ScanRequest.Builder scanRequest = ScanRequest.builder().tableName(operationContext.getTableName()).limit(this.limit).exclusiveStartKey(this.exclusiveStartKey).consistentRead(this.consistentRead);
        if (!TableMetadata.getPrimaryIndexName().equals(operationContext.getIndexName())) {
            scanRequest = scanRequest.indexName(operationContext.getIndexName());
        }
        if (this.filterExpression != null) {
            scanRequest = scanRequest.filterExpression(this.filterExpression.getExpression()).expressionAttributeValues(this.filterExpression.getExpressionValues()).expressionAttributeNames(this.filterExpression.getExpressionNames());
        }
        return (ScanRequest)scanRequest.build();
    }

    @Override
    public Iterable<Page<T>> transformResponse(ScanIterable response, TableSchema<T> tableSchema, OperationContext operationContext, MapperExtension mapperExtension) {
        return TransformIterable.of(response, this.getScanResponseIterator(tableSchema, operationContext, mapperExtension));
    }

    @Override
    public Function<ScanRequest, ScanIterable> getServiceCall(DynamoDbClient dynamoDbClient) {
        return arg_0 -> ((DynamoDbClient)dynamoDbClient).scanPaginator(arg_0);
    }

    public Map<String, AttributeValue> getExclusiveStartKey() {
        return this.exclusiveStartKey;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Boolean getConsistentRead() {
        return this.consistentRead;
    }

    public Expression getFilterExpression() {
        return this.filterExpression;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Scan scan = (Scan)o;
        if (this.exclusiveStartKey != null ? !this.exclusiveStartKey.equals(scan.exclusiveStartKey) : scan.exclusiveStartKey != null) {
            return false;
        }
        if (this.limit != null ? !this.limit.equals(scan.limit) : scan.limit != null) {
            return false;
        }
        if (this.consistentRead != null ? !this.consistentRead.equals(scan.consistentRead) : scan.consistentRead != null) {
            return false;
        }
        return this.filterExpression != null ? this.filterExpression.equals(scan.filterExpression) : scan.filterExpression == null;
    }

    public int hashCode() {
        int result = this.exclusiveStartKey != null ? this.exclusiveStartKey.hashCode() : 0;
        result = 31 * result + (this.limit != null ? this.limit.hashCode() : 0);
        result = 31 * result + (this.consistentRead != null ? this.consistentRead.hashCode() : 0);
        result = 31 * result + (this.filterExpression != null ? this.filterExpression.hashCode() : 0);
        return result;
    }

    private Function<ScanResponse, Page<T>> getScanResponseIterator(TableSchema<T> tableSchema, OperationContext operationContext, MapperExtension mapperExtension) {
        return Utils.readAndTransformPaginatedItems(tableSchema, operationContext, mapperExtension, ScanResponse::items, ScanResponse::lastEvaluatedKey);
    }

    public static final class Builder {
        private Map<String, AttributeValue> exclusiveStartKey;
        private Integer limit;
        private Boolean consistentRead;
        private Expression filterExpression;

        private Builder() {
        }

        public <T> Scan<T> build() {
            return new Scan(this.exclusiveStartKey, this.limit, this.consistentRead, this.filterExpression);
        }

        public Builder exclusiveStartKey(Map<String, AttributeValue> exclusiveStartKey) {
            this.exclusiveStartKey = exclusiveStartKey;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder consistentRead(Boolean consistentRead) {
            this.consistentRead = consistentRead;
            return this;
        }

        public Builder filterExpression(Expression filterExpression) {
            this.filterExpression = filterExpression;
            return this;
        }
    }
}

