/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.extensions.dynamodb.mappingclient.operations;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.DatabaseOperation;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.MappedTable;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.MapperExtension;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.core.Utils;
import software.amazon.awssdk.extensions.dynamodb.mappingclient.operations.WriteBatch;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemResponse;
import software.amazon.awssdk.services.dynamodb.model.DeleteRequest;
import software.amazon.awssdk.services.dynamodb.model.PutRequest;
import software.amazon.awssdk.services.dynamodb.model.WriteRequest;

@SdkPublicApi
public class BatchWriteItem
implements DatabaseOperation<BatchWriteItemRequest, BatchWriteItemResponse, BatchWriteItemResults> {
    private final Collection<WriteBatch> writeBatches;

    private BatchWriteItem(Collection<WriteBatch> writeBatches) {
        this.writeBatches = writeBatches;
    }

    public static BatchWriteItem of(Collection<WriteBatch> writeBatches) {
        return new BatchWriteItem(writeBatches);
    }

    public static BatchWriteItem of(WriteBatch ... writeBatches) {
        return new BatchWriteItem(Arrays.asList(writeBatches));
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().writeBatches(this.writeBatches);
    }

    @Override
    public BatchWriteItemRequest generateRequest(MapperExtension mapperExtension) {
        HashMap requestItems = new HashMap();
        this.writeBatches.forEach(writeBatch -> writeBatch.addWriteRequestsToMap(requestItems));
        return (BatchWriteItemRequest)BatchWriteItemRequest.builder().requestItems(Collections.unmodifiableMap(requestItems)).build();
    }

    @Override
    public BatchWriteItemResults transformResponse(BatchWriteItemResponse response, MapperExtension mapperExtension) {
        return new BatchWriteItemResults(response.unprocessedItems());
    }

    @Override
    public Function<BatchWriteItemRequest, BatchWriteItemResponse> getServiceCall(DynamoDbClient dynamoDbClient) {
        return arg_0 -> ((DynamoDbClient)dynamoDbClient).batchWriteItem(arg_0);
    }

    public Collection<WriteBatch> getWriteBatches() {
        return this.writeBatches;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BatchWriteItem that = (BatchWriteItem)o;
        return this.writeBatches != null ? this.writeBatches.equals(that.writeBatches) : that.writeBatches == null;
    }

    public int hashCode() {
        return this.writeBatches != null ? this.writeBatches.hashCode() : 0;
    }

    public static class BatchWriteItemResults {
        private final Map<String, List<WriteRequest>> unprocessedRequests;

        private BatchWriteItemResults(Map<String, List<WriteRequest>> unprocessedRequests) {
            this.unprocessedRequests = unprocessedRequests;
        }

        public <T> List<T> unprocessedPutItemsForTable(MappedTable<T> mappedTable) {
            List writeRequests = this.unprocessedRequests.getOrDefault(mappedTable.getOperationContext().getTableName(), Collections.emptyList());
            return writeRequests.stream().filter(writeRequest -> writeRequest.putRequest() != null).map(WriteRequest::putRequest).map(PutRequest::item).map(item -> Utils.readAndTransformSingleItem(item, mappedTable.getTableSchema(), mappedTable.getOperationContext(), mappedTable.getMapperExtension())).collect(Collectors.toList());
        }

        public <T> List<T> unprocessedDeleteItemsForTable(MappedTable<T> mappedTable) {
            List writeRequests = this.unprocessedRequests.getOrDefault(mappedTable.getOperationContext().getTableName(), Collections.emptyList());
            return writeRequests.stream().filter(writeRequest -> writeRequest.deleteRequest() != null).map(WriteRequest::deleteRequest).map(DeleteRequest::key).map(itemMap -> mappedTable.getTableSchema().mapToItem((Map<String, AttributeValue>)itemMap)).collect(Collectors.toList());
        }
    }

    public static final class Builder {
        private Collection<WriteBatch> writeBatches;

        private Builder() {
        }

        public Builder writeBatches(Collection<WriteBatch> writeBatches) {
            this.writeBatches = writeBatches;
            return this;
        }

        public BatchWriteItem build() {
            return new BatchWriteItem(this.writeBatches);
        }
    }
}

