/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.conditional;

import java.util.HashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.Expression;
import software.amazon.awssdk.enhanced.dynamodb.Key;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.internal.EnhancedClientUtils;
import software.amazon.awssdk.enhanced.dynamodb.internal.conditional.QueryConditionalUtils;
import software.amazon.awssdk.enhanced.dynamodb.model.QueryConditional;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
public class SingleKeyItemConditional
implements QueryConditional {
    private final Key key;
    private final String operator;

    public SingleKeyItemConditional(Key key, String operator) {
        this.key = key;
        this.operator = operator;
    }

    @Override
    public Expression expression(TableSchema<?> tableSchema, String indexName) {
        QueryConditionalUtils.KeyResolution keyResolution = QueryConditionalUtils.resolveKeys(this.key, tableSchema, indexName);
        this.validateSingleKeyConstraints(keyResolution, indexName);
        return this.buildSingleKeyExpression(keyResolution);
    }

    private void validateSingleKeyConstraints(QueryConditionalUtils.KeyResolution keyResolution, String indexName) {
        QueryConditionalUtils.validatePartitionKeyConstraints(keyResolution, indexName);
        QueryConditionalUtils.validateSortKeyConstraints(keyResolution, indexName);
        if (keyResolution.sortValues.isEmpty()) {
            throw new IllegalArgumentException(String.format("A query conditional requires a sort key to compare with, however one was not provided. Index: %s", indexName));
        }
    }

    private Expression buildSingleKeyExpression(QueryConditionalUtils.KeyResolution keyResolution) {
        StringBuilder expression = new StringBuilder();
        HashMap<String, String> names = new HashMap<String, String>();
        HashMap<String, AttributeValue> values = new HashMap<String, AttributeValue>();
        QueryConditionalUtils.addPartitionKeyConditions(expression, names, values, keyResolution.partitionKeys, keyResolution.partitionValues);
        QueryConditionalUtils.addNonRightmostSortKeyConditions(expression, names, values, keyResolution.sortKeys, keyResolution.sortValues);
        this.addOperatorCondition(expression, names, values, keyResolution);
        return QueryConditionalUtils.buildExpression(expression, names, values);
    }

    private void addOperatorCondition(StringBuilder expression, Map<String, String> names, Map<String, AttributeValue> values, QueryConditionalUtils.KeyResolution keyResolution) {
        String rightmostSortKey = keyResolution.getRightmostSortKey();
        AttributeValue rightmostSortValue = keyResolution.getRightmostSortValue();
        String keyToken = EnhancedClientUtils.keyRef(rightmostSortKey);
        String valueToken = EnhancedClientUtils.valueRef(rightmostSortKey);
        expression.append(" AND ").append(keyToken).append(" ").append(this.operator).append(" ").append(valueToken);
        names.put(keyToken, rightmostSortKey);
        values.put(valueToken, rightmostSortValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingleKeyItemConditional that = (SingleKeyItemConditional)o;
        if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
            return false;
        }
        return this.operator != null ? this.operator.equals(that.operator) : that.operator == null;
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.operator != null ? this.operator.hashCode() : 0);
        return result;
    }
}

