/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute;

import java.util.UUID;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.AttributeValueType;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.TypeConvertingVisitor;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.EnhancedAttributeValue;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.UuidStringConverter;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
@ThreadSafe
@Immutable
public final class UuidAttributeConverter
implements AttributeConverter<UUID> {
    public static final UuidStringConverter STRING_CONVERTER = UuidStringConverter.create();

    public static UuidAttributeConverter create() {
        return new UuidAttributeConverter();
    }

    @Override
    public EnhancedType<UUID> type() {
        return EnhancedType.of(UUID.class);
    }

    @Override
    public AttributeValueType attributeValueType() {
        return AttributeValueType.S;
    }

    @Override
    public AttributeValue transformFrom(UUID input) {
        return (AttributeValue)AttributeValue.builder().s(STRING_CONVERTER.toString(input)).build();
    }

    @Override
    public UUID transformTo(AttributeValue input) {
        return EnhancedAttributeValue.fromAttributeValue(input).convert(Visitor.INSTANCE);
    }

    private static final class Visitor
    extends TypeConvertingVisitor<UUID> {
        private static final Visitor INSTANCE = new Visitor();

        private Visitor() {
            super(UUID.class, UuidAttributeConverter.class);
        }

        @Override
        public UUID convertString(String value) {
            return STRING_CONVERTER.fromString(value);
        }
    }
}

