/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.mapper;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;

@SdkInternalApi
final class AnnotationUtils {
    private AnnotationUtils() {
    }

    static List<Annotation> expandAnnotations(Annotation[] ... annotationArrays) {
        if (annotationArrays == null || annotationArrays.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.stream(annotationArrays).filter(annotations -> annotations != null && ((Annotation[])annotations).length > 0).flatMap(Arrays::stream).flatMap(AnnotationUtils::expandSingleAnnotation).collect(Collectors.toList());
    }

    private static Stream<Annotation> expandSingleAnnotation(Annotation annotation) {
        if (annotation == null) {
            return Stream.empty();
        }
        List<Annotation> containerAnnotations = AnnotationUtils.extractFromContainer(annotation);
        return containerAnnotations.isEmpty() ? Stream.of(annotation) : containerAnnotations.stream();
    }

    private static List<Annotation> extractFromContainer(Annotation annotation) {
        try {
            Method valueMethod = annotation.annotationType().getDeclaredMethod("value", new Class[0]);
            Class<?> returnType = valueMethod.getReturnType();
            if (!returnType.isArray() || !returnType.getComponentType().isAnnotation()) {
                return Collections.emptyList();
            }
            Annotation[] containedAnnotations = (Annotation[])valueMethod.invoke((Object)annotation, new Object[0]);
            return containedAnnotations != null ? Arrays.asList(containedAnnotations) : Collections.emptyList();
        }
        catch (ClassCastException | IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            return Collections.emptyList();
        }
    }
}

