/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.DefaultAttributeConverterProvider;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.TableMetadata;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.internal.AttributeValues;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.utils.Validate;

@SdkPublicApi
@ThreadSafe
public final class Key {
    public static final int MAX_KEYS = 4;
    private final List<AttributeValue> partitionValues;
    private final List<AttributeValue> sortValues;

    private Key(Builder builder) {
        if (builder.partitionValues == null || builder.partitionValues.isEmpty()) {
            throw new IllegalArgumentException("partitionValues should not be null or empty");
        }
        Validate.isTrue((builder.partitionValues.size() <= 4 ? 1 : 0) != 0, (String)String.format("Maximum %s partition keys supported", 4), (Object[])new Object[0]);
        Validate.isTrue((builder.sortValues == null || builder.sortValues.size() <= 4 ? 1 : 0) != 0, (String)String.format("Maximum %s sort keys supported", 4), (Object[])new Object[0]);
        this.partitionValues = Collections.unmodifiableList(new ArrayList(builder.partitionValues));
        this.sortValues = builder.sortValues != null ? Collections.unmodifiableList(new ArrayList(builder.sortValues)) : Collections.emptyList();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Map<String, AttributeValue> keyMap(TableSchema<?> tableSchema, String index) {
        Validate.notNull(tableSchema, (String)"tableSchema must not be null", (Object[])new Object[0]);
        HashMap<String, AttributeValue> keyMap = new HashMap<String, AttributeValue>();
        List<String> partitionKeys = tableSchema.tableMetadata().indexPartitionKeys(index);
        for (int i = 0; i < partitionKeys.size() && i < this.partitionValues.size(); ++i) {
            keyMap.put(partitionKeys.get(i), this.partitionValues.get(i));
        }
        if (!this.sortValues.isEmpty()) {
            List<String> sortKeys = tableSchema.tableMetadata().indexSortKeys(index);
            if (sortKeys.isEmpty()) {
                throw new IllegalArgumentException("Sort key values were supplied for an index that does not support sort keys. Index: " + index);
            }
            for (int i = 0; i < sortKeys.size() && i < this.sortValues.size(); ++i) {
                keyMap.put(sortKeys.get(i), this.sortValues.get(i));
            }
        }
        return Collections.unmodifiableMap(keyMap);
    }

    public List<AttributeValue> partitionKeyValues() {
        return this.partitionValues;
    }

    public List<AttributeValue> sortKeyValues() {
        return this.sortValues;
    }

    public AttributeValue partitionKeyValue() {
        return this.partitionValues.isEmpty() ? null : this.partitionValues.get(0);
    }

    public Optional<AttributeValue> sortKeyValue() {
        return Optional.ofNullable(this.sortValues.isEmpty() ? null : this.sortValues.get(0));
    }

    public Map<String, AttributeValue> primaryKeyMap(TableSchema<?> tableSchema) {
        return this.keyMap(tableSchema, TableMetadata.primaryIndexName());
    }

    public Builder toBuilder() {
        return new Builder().partitionValues(this.partitionValues).sortValues(this.sortValues);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Key key = (Key)o;
        return Objects.equals(this.partitionValues, key.partitionValues) && Objects.equals(this.sortValues, key.sortValues);
    }

    public int hashCode() {
        int result = this.partitionValues == null || this.partitionValues.isEmpty() ? 0 : Key.listHashCode(this.partitionValues, 0);
        result = this.sortValues == null || this.sortValues.isEmpty() ? 31 * result : Key.listHashCode(this.sortValues, result);
        return result;
    }

    private static int listHashCode(List<AttributeValue> list, int hash) {
        int result = hash;
        for (AttributeValue value : list) {
            result = 31 * result + value.hashCode();
        }
        return result;
    }

    @NotThreadSafe
    public static final class Builder {
        private static final DefaultAttributeConverterProvider DEFAULT_CONVERTER_PROVIDER = DefaultAttributeConverterProvider.create();
        private List<AttributeValue> partitionValues = new ArrayList<AttributeValue>();
        private List<AttributeValue> sortValues = new ArrayList<AttributeValue>();

        private Builder() {
        }

        public Builder partitionValues(List<AttributeValue> partitionValues) {
            this.partitionValues = new ArrayList<AttributeValue>(partitionValues != null ? partitionValues : Collections.emptyList());
            return this;
        }

        public Builder sortValues(List<AttributeValue> sortValues) {
            this.sortValues = new ArrayList<AttributeValue>(sortValues != null ? sortValues : Collections.emptyList());
            return this;
        }

        public Builder addPartitionValue(Object value) {
            if (value == null) {
                throw new IllegalArgumentException("Partition key value cannot be null");
            }
            this.partitionValues.add(this.convertToAttributeValue(value));
            return this;
        }

        public Builder addSortValue(Object value) {
            if (value == null) {
                throw new IllegalArgumentException("Sort key value cannot be null");
            }
            this.sortValues.add(this.convertToAttributeValue(value));
            return this;
        }

        private AttributeValue convertToAttributeValue(Object value) {
            try {
                EnhancedType<?> type = EnhancedType.of(value.getClass());
                AttributeConverter<?> converter = DEFAULT_CONVERTER_PROVIDER.converterFor(type);
                return converter.transformFrom(value);
            }
            catch (IllegalStateException e) {
                throw new IllegalArgumentException("Unsupported type: " + value.getClass().getName(), e);
            }
        }

        public Builder partitionValue(AttributeValue partitionValue) {
            if (partitionValue == null || partitionValue.nul() != null && partitionValue.nul().booleanValue()) {
                throw new IllegalArgumentException("partitionValue should not be null");
            }
            this.partitionValues = Collections.singletonList(partitionValue);
            return this;
        }

        public Builder partitionValue(String partitionValue) {
            if (partitionValue == null) {
                throw new IllegalArgumentException("partitionValue should not be null");
            }
            this.partitionValues = Collections.singletonList(AttributeValues.stringValue(partitionValue));
            return this;
        }

        public Builder partitionValue(Number partitionValue) {
            if (partitionValue == null) {
                throw new IllegalArgumentException("partitionValue should not be null");
            }
            this.partitionValues = Collections.singletonList(AttributeValues.numberValue(partitionValue));
            return this;
        }

        public Builder partitionValue(SdkBytes partitionValue) {
            if (partitionValue == null) {
                throw new IllegalArgumentException("partitionValue should not be null");
            }
            this.partitionValues = Collections.singletonList(AttributeValues.binaryValue(partitionValue));
            return this;
        }

        public Builder sortValue(AttributeValue sortValue) {
            this.sortValues = sortValue != null ? Collections.singletonList(sortValue) : Collections.emptyList();
            return this;
        }

        public Builder sortValue(String sortValue) {
            this.sortValues = sortValue != null ? Collections.singletonList(AttributeValues.stringValue(sortValue)) : Collections.emptyList();
            return this;
        }

        public Builder sortValue(Number sortValue) {
            this.sortValues = sortValue != null ? Collections.singletonList(AttributeValues.numberValue(sortValue)) : Collections.emptyList();
            return this;
        }

        public Builder sortValue(SdkBytes sortValue) {
            this.sortValues = sortValue != null ? Collections.singletonList(AttributeValues.binaryValue(sortValue)) : Collections.emptyList();
            return this;
        }

        public Key build() {
            return new Key(this);
        }
    }
}

