/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.string;

import java.util.concurrent.atomic.AtomicInteger;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.StringConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.IntegerStringConverter;

@SdkInternalApi
@ThreadSafe
@Immutable
public class AtomicIntegerStringConverter
implements StringConverter<AtomicInteger> {
    private static IntegerStringConverter INTEGER_CONVERTER = IntegerStringConverter.create();

    private AtomicIntegerStringConverter() {
    }

    public static AtomicIntegerStringConverter create() {
        return new AtomicIntegerStringConverter();
    }

    @Override
    public EnhancedType<AtomicInteger> type() {
        return EnhancedType.of(AtomicInteger.class);
    }

    @Override
    public String toString(AtomicInteger object) {
        return INTEGER_CONVERTER.toString(object.get());
    }

    @Override
    public AtomicInteger fromString(String string) {
        return new AtomicInteger(INTEGER_CONVERTER.fromString(string));
    }
}

