/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.mapper;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.AttributeValueType;
import software.amazon.awssdk.enhanced.dynamodb.IndexMetadata;
import software.amazon.awssdk.enhanced.dynamodb.KeyAttributeMetadata;
import software.amazon.awssdk.enhanced.dynamodb.TableMetadata;
import software.amazon.awssdk.enhanced.dynamodb.internal.mapper.StaticIndexMetadata;
import software.amazon.awssdk.enhanced.dynamodb.internal.mapper.StaticKeyAttributeMetadata;
import software.amazon.awssdk.services.dynamodb.model.ScalarAttributeType;

@SdkPublicApi
@ThreadSafe
public final class StaticTableMetadata
implements TableMetadata {
    private final Map<String, Object> customMetadata;
    private final Map<String, IndexMetadata> indexByNameMap;
    private final Map<String, KeyAttributeMetadata> keyAttributes;

    private StaticTableMetadata(Builder builder) {
        this.customMetadata = Collections.unmodifiableMap(builder.customMetadata);
        this.indexByNameMap = Collections.unmodifiableMap(builder.indexByNameMap);
        this.keyAttributes = Collections.unmodifiableMap(builder.keyAttributes);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public <T> Optional<T> customMetadataObject(String key, Class<? extends T> objectClass) {
        Object genericObject = this.customMetadata.get(key);
        if (genericObject == null) {
            return Optional.empty();
        }
        if (!objectClass.isAssignableFrom(genericObject.getClass())) {
            throw new IllegalArgumentException("Attempt to retrieve a custom metadata object as a type that is not assignable for that object. Custom metadata key: " + key + "; requested object class: " + objectClass.getCanonicalName() + "; found object class: " + genericObject.getClass().getCanonicalName());
        }
        return Optional.of(objectClass.cast(genericObject));
    }

    @Override
    public String indexPartitionKey(String indexName) {
        IndexMetadata index = this.getIndex(indexName);
        if (!index.partitionKey().isPresent()) {
            if (!TableMetadata.primaryIndexName().equals(indexName) && index.sortKey().isPresent()) {
                return this.primaryPartitionKey();
            }
            throw new IllegalArgumentException("Attempt to execute an operation against an index that requires a partition key without assigning a partition key to that index. Index name: " + indexName);
        }
        return index.partitionKey().get().name();
    }

    @Override
    public Optional<String> indexSortKey(String indexName) {
        IndexMetadata index = this.getIndex(indexName);
        return index.sortKey().map(KeyAttributeMetadata::name);
    }

    @Override
    public Collection<String> indexKeys(String indexName) {
        IndexMetadata index = this.getIndex(indexName);
        if (index.sortKey().isPresent()) {
            if (!TableMetadata.primaryIndexName().equals(indexName) && !index.partitionKey().isPresent()) {
                return Collections.unmodifiableList(Arrays.asList(this.primaryPartitionKey(), index.sortKey().get().name()));
            }
            return Collections.unmodifiableList(Arrays.asList(index.partitionKey().get().name(), index.sortKey().get().name()));
        }
        return Collections.singletonList(index.partitionKey().get().name());
    }

    @Override
    public Collection<String> allKeys() {
        return this.keyAttributes.keySet();
    }

    @Override
    public Collection<IndexMetadata> indices() {
        return this.indexByNameMap.values();
    }

    @Override
    public Map<String, Object> customMetadata() {
        return this.customMetadata;
    }

    @Override
    public Collection<KeyAttributeMetadata> keyAttributes() {
        return this.keyAttributes.values();
    }

    private IndexMetadata getIndex(String indexName) {
        IndexMetadata index = this.indexByNameMap.get(indexName);
        if (index == null) {
            if (TableMetadata.primaryIndexName().equals(indexName)) {
                throw new IllegalArgumentException("Attempt to execute an operation that requires a primary index without defining any primary key attributes in the table metadata.");
            }
            throw new IllegalArgumentException("Attempt to execute an operation that requires a secondary index without defining the index attributes in the table metadata. Index name: " + indexName);
        }
        return index;
    }

    @Override
    public Optional<ScalarAttributeType> scalarAttributeType(String keyAttribute) {
        KeyAttributeMetadata key = this.keyAttributes.get(keyAttribute);
        if (key == null) {
            throw new IllegalArgumentException("Key attribute '" + keyAttribute + "' not found in table metadata.");
        }
        return Optional.ofNullable(key.attributeValueType().scalarAttributeType());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StaticTableMetadata that = (StaticTableMetadata)o;
        if (this.customMetadata != null ? !this.customMetadata.equals(that.customMetadata) : that.customMetadata != null) {
            return false;
        }
        if (this.indexByNameMap != null ? !this.indexByNameMap.equals(that.indexByNameMap) : that.indexByNameMap != null) {
            return false;
        }
        return this.keyAttributes != null ? this.keyAttributes.equals(that.keyAttributes) : that.keyAttributes == null;
    }

    public int hashCode() {
        int result = this.customMetadata != null ? this.customMetadata.hashCode() : 0;
        result = 31 * result + (this.indexByNameMap != null ? this.indexByNameMap.hashCode() : 0);
        result = 31 * result + (this.keyAttributes != null ? this.keyAttributes.hashCode() : 0);
        return result;
    }

    @NotThreadSafe
    public static class Builder {
        private final Map<String, Object> customMetadata = new LinkedHashMap<String, Object>();
        private final Map<String, IndexMetadata> indexByNameMap = new LinkedHashMap<String, IndexMetadata>();
        private final Map<String, KeyAttributeMetadata> keyAttributes = new LinkedHashMap<String, KeyAttributeMetadata>();

        private Builder() {
        }

        public StaticTableMetadata build() {
            return new StaticTableMetadata(this);
        }

        public Builder addCustomMetadataObject(String key, Object object) {
            if (this.customMetadata.containsKey(key)) {
                throw new IllegalArgumentException("Attempt to set a custom metadata object that has already been set. Custom metadata object key: " + key);
            }
            this.customMetadata.put(key, object);
            return this;
        }

        public Builder addCustomMetadataObject(String key, Collection<Object> objects) {
            Object collectionInMetadata = this.customMetadata.get(key);
            Collection<Object> customObjectToPut = collectionInMetadata != null ? Stream.concat(((Collection)collectionInMetadata).stream(), objects.stream()).collect(Collectors.toSet()) : objects;
            this.customMetadata.put(key, customObjectToPut);
            return this;
        }

        public Builder addCustomMetadataObject(String key, Map<Object, Object> objectMap) {
            Object collectionInMetadata = this.customMetadata.get(key);
            Map<Object, Object> customObjectToPut = collectionInMetadata != null ? Stream.concat(((Map)collectionInMetadata).entrySet().stream(), objectMap.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)) : objectMap;
            this.customMetadata.put(key, customObjectToPut);
            return this;
        }

        public Builder addIndexPartitionKey(String indexName, String attributeName, AttributeValueType attributeValueType) {
            IndexMetadata index = this.indexByNameMap.get(indexName);
            if (index != null && index.partitionKey().isPresent()) {
                throw new IllegalArgumentException("Attempt to set an index partition key that conflicts with an existing index partition key of the same name and index. Index name: " + indexName + "; attribute name: " + attributeName);
            }
            StaticKeyAttributeMetadata partitionKey = StaticKeyAttributeMetadata.create(attributeName, attributeValueType);
            this.indexByNameMap.put(indexName, StaticIndexMetadata.builderFrom(index).name(indexName).partitionKey(partitionKey).build());
            this.markAttributeAsKey(attributeName, attributeValueType);
            return this;
        }

        public Builder addIndexSortKey(String indexName, String attributeName, AttributeValueType attributeValueType) {
            IndexMetadata index = this.indexByNameMap.get(indexName);
            if (index != null && index.sortKey().isPresent()) {
                throw new IllegalArgumentException("Attempt to set an index sort key that conflicts with an existing index sort key of the same name and index. Index name: " + indexName + "; attribute name: " + attributeName);
            }
            StaticKeyAttributeMetadata sortKey = StaticKeyAttributeMetadata.create(attributeName, attributeValueType);
            this.indexByNameMap.put(indexName, StaticIndexMetadata.builderFrom(index).name(indexName).sortKey(sortKey).build());
            this.markAttributeAsKey(attributeName, attributeValueType);
            return this;
        }

        public Builder markAttributeAsKey(String attributeName, AttributeValueType attributeValueType) {
            KeyAttributeMetadata existing = this.keyAttributes.get(attributeName);
            if (existing != null && existing.attributeValueType() != attributeValueType) {
                throw new IllegalArgumentException("Attempt to mark an attribute as a key with a different AttributeValueType than one that has already been recorded.");
            }
            if (existing == null) {
                this.keyAttributes.put(attributeName, StaticKeyAttributeMetadata.create(attributeName, attributeValueType));
            }
            return this;
        }

        Builder mergeWith(TableMetadata other) {
            other.indices().forEach(index -> {
                index.partitionKey().ifPresent(partitionKey -> this.addIndexPartitionKey(index.name(), partitionKey.name(), partitionKey.attributeValueType()));
                index.sortKey().ifPresent(sortKey -> this.addIndexSortKey(index.name(), sortKey.name(), sortKey.attributeValueType()));
            });
            other.customMetadata().forEach(this::mergeCustomMetaDataObject);
            other.keyAttributes().forEach(keyAttribute -> this.markAttributeAsKey(keyAttribute.name(), keyAttribute.attributeValueType()));
            return this;
        }

        private void mergeCustomMetaDataObject(String key, Object object) {
            if (object instanceof Collection) {
                this.addCustomMetadataObject(key, (Collection)object);
            } else if (object instanceof Map) {
                this.addCustomMetadataObject(key, (Map)object);
            } else {
                this.addCustomMetadataObject(key, object);
            }
        }
    }
}

