/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.extensions.utility;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.internal.EnhancedClientUtils;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
public final class NestedRecordUtils {
    private static final Pattern NESTED_OBJECT_PATTERN = Pattern.compile("_NESTED_ATTR_UPDATE_");

    private NestedRecordUtils() {
    }

    public static TableSchema<?> getTableSchemaForListElement(TableSchema<?> rootSchema, String key) {
        TableSchema<?> listElementSchema;
        try {
            if (!key.contains("_NESTED_ATTR_UPDATE_")) {
                listElementSchema = TableSchema.fromClass(Class.forName(rootSchema.converterForAttribute(key).type().rawClassParameters().get(0).rawClass().getName()));
            } else {
                String[] parts = NESTED_OBJECT_PATTERN.split(key);
                TableSchema<?> currentSchema = rootSchema;
                for (int i = 0; i < parts.length - 1; ++i) {
                    Optional<TableSchema<?>> nestedSchema = EnhancedClientUtils.getNestedSchema(currentSchema, parts[i]);
                    if (!nestedSchema.isPresent()) continue;
                    currentSchema = nestedSchema.get();
                }
                String attributeName = parts[parts.length - 1];
                listElementSchema = TableSchema.fromClass(Class.forName(currentSchema.converterForAttribute(attributeName).type().rawClassParameters().get(0).rawClass().getName()));
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Class not found for field name: " + key, e);
        }
        return listElementSchema;
    }

    public static Map<String, TableSchema<?>> resolveSchemasPerPath(Map<String, AttributeValue> attributesToSet, TableSchema<?> rootSchema) {
        HashMap schemaMap = new HashMap();
        schemaMap.put("", rootSchema);
        for (String key : attributesToSet.keySet()) {
            String[] parts = NESTED_OBJECT_PATTERN.split(key);
            StringBuilder pathBuilder = new StringBuilder();
            TableSchema<?> currentSchema = rootSchema;
            for (int i = 0; i < parts.length - 1; ++i) {
                if (pathBuilder.length() > 0) {
                    pathBuilder.append(".");
                }
                pathBuilder.append(parts[i]);
                String path = pathBuilder.toString();
                if (!schemaMap.containsKey(path)) {
                    Optional<TableSchema<?>> nestedSchema = EnhancedClientUtils.getNestedSchema(currentSchema, parts[i]);
                    if (!nestedSchema.isPresent()) continue;
                    schemaMap.put(path, nestedSchema.get());
                    currentSchema = nestedSchema.get();
                    continue;
                }
                currentSchema = (TableSchema<?>)schemaMap.get(path);
            }
        }
        return schemaMap;
    }

    public static String reconstructCompositeKey(String path, String attributeName) {
        if (path == null || path.isEmpty()) {
            return attributeName;
        }
        return String.join((CharSequence)"_NESTED_ATTR_UPDATE_", path.split("\\.")) + "_NESTED_ATTR_UPDATE_" + attributeName;
    }
}

