/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.mapper;

import java.util.Objects;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.LongAttributeConverter;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
public final class AtomicCounter {
    public static final String KEY_PREFIX = "_";
    private static final String DELTA_ATTRIBUTE_NAME = "_Delta";
    private static final String STARTVALUE_ATTRIBUTE_NAME = "_Start";
    private final CounterAttribute delta;
    private final CounterAttribute startValue;

    private AtomicCounter(Builder builder) {
        this.delta = new CounterAttribute(builder.delta, DELTA_ATTRIBUTE_NAME);
        this.startValue = new CounterAttribute(builder.startValue, STARTVALUE_ATTRIBUTE_NAME);
    }

    public static Builder builder() {
        return new Builder();
    }

    public CounterAttribute delta() {
        return this.delta;
    }

    public CounterAttribute startValue() {
        return this.startValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtomicCounter that = (AtomicCounter)o;
        if (!Objects.equals(this.delta, that.delta)) {
            return false;
        }
        return Objects.equals(this.startValue, that.startValue);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.delta);
        result = 31 * result + Objects.hashCode(this.startValue);
        return result;
    }

    public static class CounterAttribute {
        private static final AttributeConverter<Long> CONVERTER = LongAttributeConverter.create();
        private final Long value;
        private final String name;

        CounterAttribute(Long value, String name) {
            this.value = value;
            this.name = name;
        }

        public Long value() {
            return this.value;
        }

        public String name() {
            return this.name;
        }

        public static AttributeValue resolvedValue(Long value) {
            return CONVERTER.transformFrom(value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CounterAttribute that = (CounterAttribute)o;
            if (!Objects.equals(this.value, that.value)) {
                return false;
            }
            return Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            int result = Objects.hashCode(this.value);
            result = 31 * result + Objects.hashCode(this.name);
            return result;
        }
    }

    public static final class Builder {
        private Long delta;
        private Long startValue;

        private Builder() {
        }

        public Builder delta(Long delta) {
            this.delta = delta;
            return this;
        }

        public Builder startValue(Long startValue) {
            this.startValue = startValue;
            return this;
        }

        public AtomicCounter build() {
            return new AtomicCounter(this);
        }
    }
}

