/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.extensions;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.AttributeValueType;
import software.amazon.awssdk.enhanced.dynamodb.TableMetadata;
import software.amazon.awssdk.enhanced.dynamodb.internal.mapper.AtomicCounter;
import software.amazon.awssdk.enhanced.dynamodb.mapper.StaticAttributeTag;
import software.amazon.awssdk.enhanced.dynamodb.mapper.StaticTableMetadata;

@SdkInternalApi
public class AtomicCounterTag
implements StaticAttributeTag {
    public static final String CUSTOM_METADATA_KEY_PREFIX = "AtomicCounter:Counters";
    private static final long DEFAULT_INCREMENT = 1L;
    private static final long DEFAULT_START_VALUE = 0L;
    private static final AtomicCounter DEFAULT_COUNTER = AtomicCounter.builder().delta(1L).startValue(0L).build();
    private final AtomicCounter counter;

    private AtomicCounterTag(AtomicCounter counter) {
        this.counter = counter;
    }

    public static AtomicCounterTag create() {
        return new AtomicCounterTag(DEFAULT_COUNTER);
    }

    public static AtomicCounterTag fromValues(long delta, long startValue) {
        return new AtomicCounterTag(AtomicCounter.builder().delta(delta).startValue(startValue).build());
    }

    public static Map<String, AtomicCounter> resolve(TableMetadata tableMetadata) {
        return tableMetadata.customMetadataObject(CUSTOM_METADATA_KEY_PREFIX, Map.class).orElseGet(HashMap::new);
    }

    @Override
    public Consumer<StaticTableMetadata.Builder> modifyMetadata(String attributeName, AttributeValueType attributeValueType) {
        return metadata -> metadata.addCustomMetadataObject(CUSTOM_METADATA_KEY_PREFIX, Collections.singletonMap(attributeName, this.counter)).markAttributeAsKey(attributeName, attributeValueType);
    }
}

