/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.mapper;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.AttributeValueType;
import software.amazon.awssdk.enhanced.dynamodb.TableMetadata;
import software.amazon.awssdk.enhanced.dynamodb.mapper.StaticAttributeTag;
import software.amazon.awssdk.enhanced.dynamodb.mapper.StaticTableMetadata;
import software.amazon.awssdk.enhanced.dynamodb.mapper.UpdateBehavior;

@SdkInternalApi
public class UpdateBehaviorTag
implements StaticAttributeTag {
    private static final String CUSTOM_METADATA_KEY_PREFIX = "UpdateBehavior:";
    private static final UpdateBehavior DEFAULT_UPDATE_BEHAVIOR = UpdateBehavior.WRITE_ALWAYS;
    private static final UpdateBehaviorTag WRITE_ALWAYS_TAG = new UpdateBehaviorTag(UpdateBehavior.WRITE_ALWAYS);
    private static final UpdateBehaviorTag WRITE_IF_NOT_EXISTS_TAG = new UpdateBehaviorTag(UpdateBehavior.WRITE_IF_NOT_EXISTS);
    private final UpdateBehavior updateBehavior;

    private UpdateBehaviorTag(UpdateBehavior updateBehavior) {
        this.updateBehavior = updateBehavior;
    }

    public static UpdateBehaviorTag fromUpdateBehavior(UpdateBehavior updateBehavior) {
        switch (updateBehavior) {
            case WRITE_ALWAYS: {
                return WRITE_ALWAYS_TAG;
            }
            case WRITE_IF_NOT_EXISTS: {
                return WRITE_IF_NOT_EXISTS_TAG;
            }
        }
        throw new IllegalArgumentException("Update behavior '" + (Object)((Object)updateBehavior) + "' not supported");
    }

    public static UpdateBehavior resolveForAttribute(String attributeName, TableMetadata tableMetadata) {
        String metadataKey = CUSTOM_METADATA_KEY_PREFIX + attributeName;
        return tableMetadata.customMetadataObject(metadataKey, UpdateBehavior.class).orElse(DEFAULT_UPDATE_BEHAVIOR);
    }

    @Override
    public Consumer<StaticTableMetadata.Builder> modifyMetadata(String attributeName, AttributeValueType attributeValueType) {
        return metadata -> metadata.addCustomMetadataObject(CUSTOM_METADATA_KEY_PREFIX + attributeName, (Object)this.updateBehavior);
    }
}

