/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.update;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.Expression;
import software.amazon.awssdk.enhanced.dynamodb.update.AddAction;
import software.amazon.awssdk.enhanced.dynamodb.update.DeleteAction;
import software.amazon.awssdk.enhanced.dynamodb.update.RemoveAction;
import software.amazon.awssdk.enhanced.dynamodb.update.SetAction;
import software.amazon.awssdk.enhanced.dynamodb.update.UpdateExpression;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
public final class UpdateExpressionConverter {
    private static final String REMOVE = "REMOVE ";
    private static final String SET = "SET ";
    private static final String DELETE = "DELETE ";
    private static final String ADD = "ADD ";
    private static final String ACTION_SEPARATOR = ", ";
    private static final String GROUP_SEPARATOR = " ";
    private static final char DOT = '.';
    private static final char LEFT_BRACKET = '[';

    private UpdateExpressionConverter() {
    }

    public static Expression toExpression(UpdateExpression expression) {
        if (expression == null) {
            return null;
        }
        Map<String, AttributeValue> expressionValues = UpdateExpressionConverter.mergeExpressionValues(expression);
        Map<String, String> expressionNames = UpdateExpressionConverter.mergeExpressionNames(expression);
        List<String> groupExpressions = UpdateExpressionConverter.groupExpressions(expression);
        return Expression.builder().expression(String.join((CharSequence)GROUP_SEPARATOR, groupExpressions)).expressionNames(expressionNames).expressionValues(expressionValues).build();
    }

    public static List<String> findAttributeNames(UpdateExpression updateExpression) {
        if (updateExpression == null) {
            return Collections.emptyList();
        }
        List<String> attributeNames = UpdateExpressionConverter.listPathsWithoutTokens(updateExpression);
        List<String> attributeNamesFromTokens = UpdateExpressionConverter.listAttributeNamesFromTokens(updateExpression);
        attributeNames.addAll(attributeNamesFromTokens);
        return attributeNames;
    }

    private static List<String> groupExpressions(UpdateExpression expression) {
        ArrayList<String> groupExpressions = new ArrayList<String>();
        if (!expression.setActions().isEmpty()) {
            groupExpressions.add(SET + expression.setActions().stream().map(a -> String.format("%s = %s", a.path(), a.value())).collect(Collectors.joining(ACTION_SEPARATOR)));
        }
        if (!expression.removeActions().isEmpty()) {
            groupExpressions.add(REMOVE + expression.removeActions().stream().map(RemoveAction::path).collect(Collectors.joining(ACTION_SEPARATOR)));
        }
        if (!expression.deleteActions().isEmpty()) {
            groupExpressions.add(DELETE + expression.deleteActions().stream().map(a -> String.format("%s %s", a.path(), a.value())).collect(Collectors.joining(ACTION_SEPARATOR)));
        }
        if (!expression.addActions().isEmpty()) {
            groupExpressions.add(ADD + expression.addActions().stream().map(a -> String.format("%s %s", a.path(), a.value())).collect(Collectors.joining(ACTION_SEPARATOR)));
        }
        return groupExpressions;
    }

    private static Stream<Map<String, String>> streamOfExpressionNames(UpdateExpression expression) {
        return Stream.concat(expression.setActions().stream().map(SetAction::expressionNames), Stream.concat(expression.removeActions().stream().map(RemoveAction::expressionNames), Stream.concat(expression.deleteActions().stream().map(DeleteAction::expressionNames), expression.addActions().stream().map(AddAction::expressionNames))));
    }

    private static Map<String, AttributeValue> mergeExpressionValues(UpdateExpression expression) {
        return UpdateExpressionConverter.streamOfExpressionValues(expression).reduce(Expression::joinValues).orElseGet(Collections::emptyMap);
    }

    private static Stream<Map<String, AttributeValue>> streamOfExpressionValues(UpdateExpression expression) {
        return Stream.concat(expression.setActions().stream().map(SetAction::expressionValues), Stream.concat(expression.deleteActions().stream().map(DeleteAction::expressionValues), expression.addActions().stream().map(AddAction::expressionValues)));
    }

    private static Map<String, String> mergeExpressionNames(UpdateExpression expression) {
        return UpdateExpressionConverter.streamOfExpressionNames(expression).reduce(Expression::joinNames).orElseGet(Collections::emptyMap);
    }

    private static List<String> listPathsWithoutTokens(UpdateExpression expression) {
        return Stream.concat(expression.setActions().stream().map(SetAction::path), Stream.concat(expression.removeActions().stream().map(RemoveAction::path), Stream.concat(expression.deleteActions().stream().map(DeleteAction::path), expression.addActions().stream().map(AddAction::path)))).map(UpdateExpressionConverter::removeNestingAndListReference).filter(attributeName -> !attributeName.contains("#")).collect(Collectors.toList());
    }

    private static List<String> listAttributeNamesFromTokens(UpdateExpression updateExpression) {
        return UpdateExpressionConverter.mergeExpressionNames(updateExpression).values().stream().map(UpdateExpressionConverter::removeNestingAndListReference).collect(Collectors.toList());
    }

    private static String removeNestingAndListReference(String attributeName) {
        return attributeName.substring(0, UpdateExpressionConverter.getRemovalIndex(attributeName));
    }

    private static int getRemovalIndex(String attributeName) {
        for (int i = 0; i < attributeName.length(); ++i) {
            char c = attributeName.charAt(i);
            if (c != '.' && c != '[') continue;
            return attributeName.indexOf(c);
        }
        return attributeName.length();
    }
}

