/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.operations;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbEnhancedClientExtension;
import software.amazon.awssdk.enhanced.dynamodb.OperationContext;
import software.amazon.awssdk.enhanced.dynamodb.TableMetadata;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.OperationName;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.TableOperation;
import software.amazon.awssdk.enhanced.dynamodb.model.CreateTableEnhancedRequest;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.BillingMode;
import software.amazon.awssdk.services.dynamodb.model.CreateTableRequest;
import software.amazon.awssdk.services.dynamodb.model.CreateTableResponse;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndex;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.KeyType;
import software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndex;

@SdkInternalApi
public class CreateTableOperation<T>
implements TableOperation<T, CreateTableRequest, CreateTableResponse, Void> {
    private final CreateTableEnhancedRequest request;

    private CreateTableOperation(CreateTableEnhancedRequest request) {
        this.request = request;
    }

    public static <T> CreateTableOperation<T> create(CreateTableEnhancedRequest request) {
        return new CreateTableOperation<T>(request);
    }

    @Override
    public OperationName operationName() {
        return OperationName.CREATE_TABLE;
    }

    @Override
    public CreateTableRequest generateRequest(TableSchema<T> tableSchema, OperationContext operationContext, DynamoDbEnhancedClientExtension extension) {
        if (!TableMetadata.primaryIndexName().equals(operationContext.indexName())) {
            throw new IllegalArgumentException("PutItem cannot be executed against a secondary index.");
        }
        String primaryPartitionKey = tableSchema.tableMetadata().primaryPartitionKey();
        Optional<String> primarySortKey = tableSchema.tableMetadata().primarySortKey();
        HashSet<String> dedupedIndexKeys = new HashSet<String>();
        dedupedIndexKeys.add(primaryPartitionKey);
        primarySortKey.ifPresent(dedupedIndexKeys::add);
        List sdkGlobalSecondaryIndices = null;
        List sdkLocalSecondaryIndices = null;
        if (this.request.globalSecondaryIndices() != null && !this.request.globalSecondaryIndices().isEmpty()) {
            sdkGlobalSecondaryIndices = this.request.globalSecondaryIndices().stream().map(gsi -> {
                String indexPartitionKey = tableSchema.tableMetadata().indexPartitionKey(gsi.indexName());
                Optional<String> indexSortKey = tableSchema.tableMetadata().indexSortKey(gsi.indexName());
                dedupedIndexKeys.add(indexPartitionKey);
                indexSortKey.ifPresent(dedupedIndexKeys::add);
                return (GlobalSecondaryIndex)GlobalSecondaryIndex.builder().indexName(gsi.indexName()).keySchema(CreateTableOperation.generateKeySchema(indexPartitionKey, indexSortKey.orElse(null))).projection(gsi.projection()).provisionedThroughput(gsi.provisionedThroughput()).build();
            }).collect(Collectors.toList());
        }
        if (this.request.localSecondaryIndices() != null && !this.request.localSecondaryIndices().isEmpty()) {
            sdkLocalSecondaryIndices = this.request.localSecondaryIndices().stream().map(lsi -> {
                Optional<String> indexSortKey = tableSchema.tableMetadata().indexSortKey(lsi.indexName());
                indexSortKey.ifPresent(dedupedIndexKeys::add);
                if (!primaryPartitionKey.equals(tableSchema.tableMetadata().indexPartitionKey(lsi.indexName()))) {
                    throw new IllegalArgumentException("Attempt to create a local secondary index with a partition key that is not the primary partition key. Index name: " + lsi.indexName());
                }
                return (LocalSecondaryIndex)LocalSecondaryIndex.builder().indexName(lsi.indexName()).keySchema(CreateTableOperation.generateKeySchema(primaryPartitionKey, indexSortKey.orElse(null))).projection(lsi.projection()).build();
            }).collect(Collectors.toList());
        }
        List attributeDefinitions = dedupedIndexKeys.stream().map(attribute -> (AttributeDefinition)AttributeDefinition.builder().attributeName(attribute).attributeType(tableSchema.tableMetadata().scalarAttributeType((String)attribute).orElseThrow(() -> new IllegalArgumentException("Could not map the key attribute '" + attribute + "' to a valid scalar type."))).build()).collect(Collectors.toList());
        BillingMode billingMode = this.request.provisionedThroughput() == null ? BillingMode.PAY_PER_REQUEST : BillingMode.PROVISIONED;
        return (CreateTableRequest)CreateTableRequest.builder().tableName(operationContext.tableName()).keySchema(CreateTableOperation.generateKeySchema(primaryPartitionKey, primarySortKey.orElse(null))).globalSecondaryIndexes(sdkGlobalSecondaryIndices).localSecondaryIndexes(sdkLocalSecondaryIndices).attributeDefinitions(attributeDefinitions).billingMode(billingMode).provisionedThroughput(this.request.provisionedThroughput()).build();
    }

    @Override
    public Function<CreateTableRequest, CreateTableResponse> serviceCall(DynamoDbClient dynamoDbClient) {
        return arg_0 -> ((DynamoDbClient)dynamoDbClient).createTable(arg_0);
    }

    @Override
    public Function<CreateTableRequest, CompletableFuture<CreateTableResponse>> asyncServiceCall(DynamoDbAsyncClient dynamoDbAsyncClient) {
        return arg_0 -> ((DynamoDbAsyncClient)dynamoDbAsyncClient).createTable(arg_0);
    }

    @Override
    public Void transformResponse(CreateTableResponse response, TableSchema<T> tableSchema, OperationContext operationContext, DynamoDbEnhancedClientExtension extension) {
        return null;
    }

    private static Collection<KeySchemaElement> generateKeySchema(String partitionKey, String sortKey) {
        if (sortKey == null) {
            return CreateTableOperation.generateKeySchema(partitionKey);
        }
        return Collections.unmodifiableList(Arrays.asList((KeySchemaElement)KeySchemaElement.builder().attributeName(partitionKey).keyType(KeyType.HASH).build(), (KeySchemaElement)KeySchemaElement.builder().attributeName(sortKey).keyType(KeyType.RANGE).build()));
    }

    private static Collection<KeySchemaElement> generateKeySchema(String partitionKey) {
        return Collections.singletonList(KeySchemaElement.builder().attributeName(partitionKey).keyType(KeyType.HASH).build());
    }
}

