/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.model.ReadBatch;
import software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity;

@SdkPublicApi
@ThreadSafe
public final class BatchGetItemEnhancedRequest {
    private final List<ReadBatch> readBatches;
    private final String returnConsumedCapacity;

    private BatchGetItemEnhancedRequest(Builder builder) {
        this.readBatches = BatchGetItemEnhancedRequest.getListIfExist(builder.readBatches);
        this.returnConsumedCapacity = builder.returnConsumedCapacity;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().readBatches(this.readBatches).returnConsumedCapacity(this.returnConsumedCapacity);
    }

    public Collection<ReadBatch> readBatches() {
        return this.readBatches;
    }

    public ReturnConsumedCapacity returnConsumedCapacity() {
        return ReturnConsumedCapacity.fromValue((String)this.returnConsumedCapacity);
    }

    public String returnConsumedCapacityAsString() {
        return this.returnConsumedCapacity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BatchGetItemEnhancedRequest that = (BatchGetItemEnhancedRequest)o;
        return Objects.equals(this.readBatches, that.readBatches) && Objects.equals(this.returnConsumedCapacity, that.returnConsumedCapacity);
    }

    public int hashCode() {
        int hc = this.readBatches != null ? this.readBatches.hashCode() : 0;
        hc = 31 * hc + (this.returnConsumedCapacity != null ? this.returnConsumedCapacity.hashCode() : 0);
        return hc;
    }

    private static List<ReadBatch> getListIfExist(List<ReadBatch> readBatches) {
        return readBatches != null ? Collections.unmodifiableList(readBatches) : null;
    }

    @NotThreadSafe
    public static final class Builder {
        private List<ReadBatch> readBatches;
        private String returnConsumedCapacity;

        private Builder() {
        }

        public Builder readBatches(Collection<ReadBatch> readBatches) {
            this.readBatches = readBatches != null ? new ArrayList<ReadBatch>(readBatches) : null;
            return this;
        }

        public Builder readBatches(ReadBatch ... readBatches) {
            this.readBatches = Arrays.asList(readBatches);
            return this;
        }

        public Builder addReadBatch(ReadBatch readBatch) {
            if (this.readBatches == null) {
                this.readBatches = new ArrayList<ReadBatch>();
            }
            this.readBatches.add(readBatch);
            return this;
        }

        public Builder returnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity == null ? null : returnConsumedCapacity.toString();
            return this;
        }

        public Builder returnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
            return this;
        }

        public BatchGetItemEnhancedRequest build() {
            return new BatchGetItemEnhancedRequest(this);
        }
    }
}

