/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.model;

import java.util.Objects;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.enhanced.dynamodb.Expression;

@SdkPublicApi
public final class UpdateItemEnhancedRequest<T> {
    private final T item;
    private final Boolean ignoreNulls;
    private final Expression conditionExpression;

    private UpdateItemEnhancedRequest(Builder<T> builder) {
        this.item = ((Builder)builder).item;
        this.ignoreNulls = ((Builder)builder).ignoreNulls;
        this.conditionExpression = ((Builder)builder).conditionExpression;
    }

    public static <T> Builder<T> builder(Class<? extends T> itemClass) {
        return new Builder();
    }

    public Builder<T> toBuilder() {
        return new Builder<T>().item(this.item).ignoreNulls(this.ignoreNulls).conditionExpression(this.conditionExpression);
    }

    public T item() {
        return this.item;
    }

    public Boolean ignoreNulls() {
        return this.ignoreNulls;
    }

    public Expression conditionExpression() {
        return this.conditionExpression;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateItemEnhancedRequest that = (UpdateItemEnhancedRequest)o;
        return Objects.equals(this.item, that.item) && Objects.equals(this.ignoreNulls, that.ignoreNulls) && Objects.equals(this.conditionExpression, that.conditionExpression);
    }

    public int hashCode() {
        int result = this.item != null ? this.item.hashCode() : 0;
        result = 31 * result + (this.ignoreNulls != null ? this.ignoreNulls.hashCode() : 0);
        result = 31 * result + (this.conditionExpression != null ? this.conditionExpression.hashCode() : 0);
        return result;
    }

    public static final class Builder<T> {
        private T item;
        private Boolean ignoreNulls;
        private Expression conditionExpression;

        private Builder() {
        }

        public Builder<T> ignoreNulls(Boolean ignoreNulls) {
            this.ignoreNulls = ignoreNulls;
            return this;
        }

        public Builder<T> conditionExpression(Expression conditionExpression) {
            this.conditionExpression = conditionExpression;
            return this;
        }

        public Builder<T> item(T item) {
            this.item = item;
            return this;
        }

        public UpdateItemEnhancedRequest<T> build() {
            return new UpdateItemEnhancedRequest(this);
        }
    }
}

