/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute;

import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.AttributeValueType;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.ConverterUtils;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.PrimitiveConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.TypeConvertingVisitor;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.EnhancedAttributeValue;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.FloatStringConverter;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
@ThreadSafe
@Immutable
public final class FloatAttributeConverter
implements AttributeConverter<Float>,
PrimitiveConverter<Float> {
    private static final Visitor VISITOR = new Visitor();
    private static final FloatStringConverter STRING_CONVERTER = FloatStringConverter.create();

    private FloatAttributeConverter() {
    }

    public static FloatAttributeConverter create() {
        return new FloatAttributeConverter();
    }

    @Override
    public EnhancedType<Float> type() {
        return EnhancedType.of(Float.class);
    }

    @Override
    public AttributeValueType attributeValueType() {
        return AttributeValueType.N;
    }

    @Override
    public AttributeValue transformFrom(Float input) {
        ConverterUtils.validateFloat(input);
        return (AttributeValue)AttributeValue.builder().n(STRING_CONVERTER.toString(input)).build();
    }

    @Override
    public Float transformTo(AttributeValue input) {
        Float result = input.n() != null ? EnhancedAttributeValue.fromNumber(input.n()).convert(VISITOR) : EnhancedAttributeValue.fromAttributeValue(input).convert(VISITOR);
        ConverterUtils.validateFloat(result);
        return result;
    }

    @Override
    public EnhancedType<Float> primitiveType() {
        return EnhancedType.of(Float.TYPE);
    }

    private static final class Visitor
    extends TypeConvertingVisitor<Float> {
        private Visitor() {
            super(Float.class, FloatAttributeConverter.class);
        }

        @Override
        public Float convertString(String value) {
            return STRING_CONVERTER.fromString(value);
        }

        @Override
        public Float convertNumber(String value) {
            return STRING_CONVERTER.fromString(value);
        }
    }
}

