/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.extensions;

import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.enhanced.dynamodb.AttributeValueType;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbEnhancedClientExtension;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbExtensionContext;
import software.amazon.awssdk.enhanced.dynamodb.Expression;
import software.amazon.awssdk.enhanced.dynamodb.extensions.WriteModification;
import software.amazon.awssdk.enhanced.dynamodb.internal.EnhancedClientUtils;
import software.amazon.awssdk.enhanced.dynamodb.mapper.StaticAttributeTag;
import software.amazon.awssdk.enhanced.dynamodb.mapper.StaticTableMetadata;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkPublicApi
public final class VersionedRecordExtension
implements DynamoDbEnhancedClientExtension {
    private static final Function<String, String> EXPRESSION_KEY_MAPPER = key -> ":old_" + key + "_value";
    private static final String CUSTOM_METADATA_KEY = "VersionedRecordExtension:VersionAttribute";
    private static final VersionAttribute VERSION_ATTRIBUTE = new VersionAttribute();

    private VersionedRecordExtension() {
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public WriteModification beforeWrite(DynamoDbExtensionContext.BeforeWrite context) {
        Expression condition;
        AttributeValue newVersionValue;
        Optional<String> versionAttributeKey = context.tableMetadata().customMetadataObject(CUSTOM_METADATA_KEY, String.class);
        if (!versionAttributeKey.isPresent()) {
            return WriteModification.builder().build();
        }
        HashMap<String, AttributeValue> itemToTransform = new HashMap<String, AttributeValue>(context.items());
        Optional existingVersionValue = Optional.ofNullable(itemToTransform.get(versionAttributeKey.get()));
        if (!existingVersionValue.isPresent() || EnhancedClientUtils.isNullAttributeValue((AttributeValue)existingVersionValue.get())) {
            newVersionValue = (AttributeValue)AttributeValue.builder().n("1").build();
            condition = Expression.builder().expression(String.format("attribute_not_exists(%s)", versionAttributeKey.get())).build();
        } else {
            if (((AttributeValue)existingVersionValue.get()).n() == null) {
                throw new IllegalArgumentException("Version attribute appears to be the wrong type. N is required.");
            }
            int existingVersion = Integer.parseInt(((AttributeValue)existingVersionValue.get()).n());
            String existingVersionValueKey = EXPRESSION_KEY_MAPPER.apply(versionAttributeKey.get());
            newVersionValue = (AttributeValue)AttributeValue.builder().n(Integer.toString(existingVersion + 1)).build();
            condition = Expression.builder().expression(String.format("%s = %s", versionAttributeKey.get(), existingVersionValueKey)).expressionValues(Collections.singletonMap(existingVersionValueKey, existingVersionValue.get())).build();
        }
        itemToTransform.put(versionAttributeKey.get(), newVersionValue);
        return WriteModification.builder().transformedItem(Collections.unmodifiableMap(itemToTransform)).additionalConditionalExpression(condition).build();
    }

    public static final class Builder {
        private Builder() {
        }

        public VersionedRecordExtension build() {
            return new VersionedRecordExtension();
        }
    }

    private static class VersionAttribute
    implements StaticAttributeTag {
        private VersionAttribute() {
        }

        @Override
        public Consumer<StaticTableMetadata.Builder> modifyMetadata(String attributeName, AttributeValueType attributeValueType) {
            if (attributeValueType != AttributeValueType.N) {
                throw new IllegalArgumentException(String.format("Attribute '%s' of type %s is not a suitable type to be used as a version attribute. Only type 'N' is supported.", attributeName, attributeValueType.name()));
            }
            return metadata -> metadata.addCustomMetadataObject(VersionedRecordExtension.CUSTOM_METADATA_KEY, attributeName).markAttributeAsKey(attributeName, attributeValueType);
        }
    }

    public static final class AttributeTags {
        private AttributeTags() {
        }

        public static StaticAttributeTag versionAttribute() {
            return VERSION_ATTRIBUTE;
        }
    }
}

