/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute;

import java.util.OptionalInt;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.AttributeValueType;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.internal.AttributeValues;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.TypeConvertingVisitor;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.EnhancedAttributeValue;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.OptionalIntStringConverter;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
@ThreadSafe
@Immutable
public final class OptionalIntAttributeConverter
implements AttributeConverter<OptionalInt> {
    private static final Visitor VISITOR = new Visitor();
    private static final OptionalIntStringConverter STRING_CONVERTER = OptionalIntStringConverter.create();

    private OptionalIntAttributeConverter() {
    }

    @Override
    public EnhancedType<OptionalInt> type() {
        return EnhancedType.of(OptionalInt.class);
    }

    @Override
    public AttributeValueType attributeValueType() {
        return AttributeValueType.N;
    }

    public static OptionalIntAttributeConverter create() {
        return new OptionalIntAttributeConverter();
    }

    @Override
    public AttributeValue transformFrom(OptionalInt input) {
        if (input.isPresent()) {
            return (AttributeValue)AttributeValue.builder().n(STRING_CONVERTER.toString(input)).build();
        }
        return AttributeValues.nullAttributeValue();
    }

    @Override
    public OptionalInt transformTo(AttributeValue input) {
        if (input.n() != null) {
            return EnhancedAttributeValue.fromNumber(input.n()).convert(VISITOR);
        }
        return EnhancedAttributeValue.fromAttributeValue(input).convert(VISITOR);
    }

    private static final class Visitor
    extends TypeConvertingVisitor<OptionalInt> {
        private Visitor() {
            super(OptionalInt.class, OptionalIntAttributeConverter.class);
        }

        @Override
        public OptionalInt convertNull() {
            return OptionalInt.empty();
        }

        @Override
        public OptionalInt convertString(String value) {
            return STRING_CONVERTER.fromString(value);
        }

        @Override
        public OptionalInt convertNumber(String value) {
            return STRING_CONVERTER.fromString(value);
        }
    }
}

