/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute;

import java.time.Duration;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.AttributeValueType;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.ConverterUtils;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.TypeConvertingVisitor;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.EnhancedAttributeValue;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
@ThreadSafe
@Immutable
public final class DurationAttributeConverter
implements AttributeConverter<Duration> {
    private static final Visitor VISITOR = new Visitor();

    private DurationAttributeConverter() {
    }

    public static DurationAttributeConverter create() {
        return new DurationAttributeConverter();
    }

    @Override
    public EnhancedType<Duration> type() {
        return EnhancedType.of(Duration.class);
    }

    @Override
    public AttributeValueType attributeValueType() {
        return AttributeValueType.N;
    }

    @Override
    public AttributeValue transformFrom(Duration input) {
        return (AttributeValue)AttributeValue.builder().n(input.getSeconds() + (input.getNano() == 0 ? "" : "." + ConverterUtils.padLeft(9, input.getNano()))).build();
    }

    @Override
    public Duration transformTo(AttributeValue input) {
        if (input.n() != null) {
            return EnhancedAttributeValue.fromNumber(input.n()).convert(VISITOR);
        }
        return EnhancedAttributeValue.fromAttributeValue(input).convert(VISITOR);
    }

    private static final class Visitor
    extends TypeConvertingVisitor<Duration> {
        private Visitor() {
            super(Duration.class, DurationAttributeConverter.class);
        }

        @Override
        public Duration convertNumber(String value) {
            String[] splitOnDecimal = ConverterUtils.splitNumberOnDecimal(value);
            long seconds = Long.parseLong(splitOnDecimal[0]);
            int nanoAdjustment = Integer.parseInt(splitOnDecimal[1]);
            if (seconds < 0L) {
                nanoAdjustment = -nanoAdjustment;
            }
            return Duration.ofSeconds(seconds, nanoAdjustment);
        }
    }
}

