/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.operations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbEnhancedClientExtension;
import software.amazon.awssdk.enhanced.dynamodb.Expression;
import software.amazon.awssdk.enhanced.dynamodb.OperationContext;
import software.amazon.awssdk.enhanced.dynamodb.TableMetadata;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.extensions.WriteModification;
import software.amazon.awssdk.enhanced.dynamodb.internal.EnhancedClientUtils;
import software.amazon.awssdk.enhanced.dynamodb.internal.extensions.DefaultDynamoDbExtensionContext;
import software.amazon.awssdk.enhanced.dynamodb.internal.mapper.UpdateBehaviorTag;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.TableOperation;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.TransactableWriteOperation;
import software.amazon.awssdk.enhanced.dynamodb.mapper.UpdateBehavior;
import software.amazon.awssdk.enhanced.dynamodb.model.UpdateItemEnhancedRequest;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ReturnValue;
import software.amazon.awssdk.services.dynamodb.model.TransactWriteItem;
import software.amazon.awssdk.services.dynamodb.model.Update;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemResponse;

@SdkInternalApi
public class UpdateItemOperation<T>
implements TableOperation<T, UpdateItemRequest, UpdateItemResponse, T>,
TransactableWriteOperation<T> {
    private static final Function<String, String> EXPRESSION_VALUE_KEY_MAPPER = key -> ":AMZN_MAPPED_" + EnhancedClientUtils.cleanAttributeName(key);
    private static final Function<String, String> EXPRESSION_KEY_MAPPER = key -> "#AMZN_MAPPED_" + EnhancedClientUtils.cleanAttributeName(key);
    private static final Function<String, String> CONDITIONAL_UPDATE_MAPPER = key -> "if_not_exists(" + EXPRESSION_KEY_MAPPER.apply((String)key) + ", " + EXPRESSION_VALUE_KEY_MAPPER.apply((String)key) + ")";
    private final UpdateItemEnhancedRequest<T> request;

    private UpdateItemOperation(UpdateItemEnhancedRequest<T> request) {
        this.request = request;
    }

    public static <T> UpdateItemOperation<T> create(UpdateItemEnhancedRequest<T> request) {
        return new UpdateItemOperation<T>(request);
    }

    @Override
    public UpdateItemRequest generateRequest(TableSchema<T> tableSchema, OperationContext operationContext, DynamoDbEnhancedClientExtension extension) {
        WriteModification transformation;
        if (!TableMetadata.primaryIndexName().equals(operationContext.indexName())) {
            throw new IllegalArgumentException("UpdateItem cannot be executed against a secondary index.");
        }
        Map<String, AttributeValue> itemMap = tableSchema.itemToMap(this.request.item(), Boolean.TRUE.equals(this.request.ignoreNulls()));
        TableMetadata tableMetadata = tableSchema.tableMetadata();
        WriteModification writeModification = transformation = extension != null ? extension.beforeWrite(DefaultDynamoDbExtensionContext.builder().items(itemMap).operationContext(operationContext).tableMetadata(tableMetadata).build()) : null;
        if (transformation != null && transformation.transformedItem() != null) {
            itemMap = transformation.transformedItem();
        }
        Collection<String> primaryKeys = tableSchema.tableMetadata().primaryKeys();
        Map<String, AttributeValue> keyAttributeValues = itemMap.entrySet().stream().filter(entry -> primaryKeys.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        UpdateItemRequest.Builder requestBuilder = UpdateItemRequest.builder().tableName(operationContext.tableName()).key(keyAttributeValues).returnValues(ReturnValue.ALL_NEW);
        Map<String, AttributeValue> filteredAttributeValues = itemMap.entrySet().stream().filter(entry -> !primaryKeys.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        requestBuilder = this.addExpressionsIfExist(transformation, filteredAttributeValues, requestBuilder, tableMetadata);
        return (UpdateItemRequest)requestBuilder.build();
    }

    @Override
    public T transformResponse(UpdateItemResponse response, TableSchema<T> tableSchema, OperationContext operationContext, DynamoDbEnhancedClientExtension extension) {
        try {
            return EnhancedClientUtils.readAndTransformSingleItem(response.attributes(), tableSchema, operationContext, extension);
        }
        catch (RuntimeException e) {
            throw new IllegalStateException("Unable to read the new item returned by UpdateItem after the update occurred. Rollbacks are not supported by this operation, therefore the record may no longer be readable using this model.", e);
        }
    }

    @Override
    public Function<UpdateItemRequest, UpdateItemResponse> serviceCall(DynamoDbClient dynamoDbClient) {
        return arg_0 -> ((DynamoDbClient)dynamoDbClient).updateItem(arg_0);
    }

    @Override
    public Function<UpdateItemRequest, CompletableFuture<UpdateItemResponse>> asyncServiceCall(DynamoDbAsyncClient dynamoDbAsyncClient) {
        return arg_0 -> ((DynamoDbAsyncClient)dynamoDbAsyncClient).updateItem(arg_0);
    }

    @Override
    public TransactWriteItem generateTransactWriteItem(TableSchema<T> tableSchema, OperationContext operationContext, DynamoDbEnhancedClientExtension dynamoDbEnhancedClientExtension) {
        UpdateItemRequest updateItemRequest = this.generateRequest(tableSchema, operationContext, dynamoDbEnhancedClientExtension);
        Update update = (Update)Update.builder().key(updateItemRequest.key()).tableName(updateItemRequest.tableName()).updateExpression(updateItemRequest.updateExpression()).conditionExpression(updateItemRequest.conditionExpression()).expressionAttributeValues(updateItemRequest.expressionAttributeValues()).expressionAttributeNames(updateItemRequest.expressionAttributeNames()).build();
        return (TransactWriteItem)TransactWriteItem.builder().update(update).build();
    }

    private static Expression generateUpdateExpression(Map<String, AttributeValue> attributeValuesToUpdate, TableMetadata tableMetadata) {
        ArrayList updateSetActions = new ArrayList();
        ArrayList updateRemoveActions = new ArrayList();
        attributeValuesToUpdate.forEach((key, value) -> {
            if (!EnhancedClientUtils.isNullAttributeValue(value)) {
                UpdateBehavior updateBehavior = UpdateBehaviorTag.resolveForAttribute(key, tableMetadata);
                updateSetActions.add(EXPRESSION_KEY_MAPPER.apply((String)key) + " = " + UpdateItemOperation.updateExpressionMapperForBehavior(updateBehavior).apply((String)key));
            } else {
                updateRemoveActions.add(EXPRESSION_KEY_MAPPER.apply((String)key));
            }
        });
        ArrayList<String> updateActions = new ArrayList<String>();
        if (!updateSetActions.isEmpty()) {
            updateActions.add("SET " + String.join((CharSequence)", ", updateSetActions));
        }
        if (!updateRemoveActions.isEmpty()) {
            updateActions.add("REMOVE " + String.join((CharSequence)", ", updateRemoveActions));
        }
        String updateExpression = String.join((CharSequence)" ", updateActions);
        Map<String, AttributeValue> expressionAttributeValues = attributeValuesToUpdate.entrySet().stream().filter(entry -> !EnhancedClientUtils.isNullAttributeValue((AttributeValue)entry.getValue())).collect(Collectors.toMap(entry -> EXPRESSION_VALUE_KEY_MAPPER.apply((String)entry.getKey()), Map.Entry::getValue));
        Map<String, String> expressionAttributeNames = attributeValuesToUpdate.keySet().stream().collect(Collectors.toMap(EXPRESSION_KEY_MAPPER, key -> key));
        return Expression.builder().expression(updateExpression).expressionValues(Collections.unmodifiableMap(expressionAttributeValues)).expressionNames(expressionAttributeNames).build();
    }

    private static Function<String, String> updateExpressionMapperForBehavior(UpdateBehavior updateBehavior) {
        switch (updateBehavior) {
            case WRITE_ALWAYS: {
                return EXPRESSION_VALUE_KEY_MAPPER;
            }
            case WRITE_IF_NOT_EXISTS: {
                return CONDITIONAL_UPDATE_MAPPER;
            }
        }
        throw new IllegalArgumentException("Unsupported update behavior '" + (Object)((Object)updateBehavior) + "'");
    }

    private UpdateItemRequest.Builder addExpressionsIfExist(WriteModification transformation, Map<String, AttributeValue> filteredAttributeValues, UpdateItemRequest.Builder requestBuilder, TableMetadata tableMetadata) {
        Map<String, String> expressionNames = null;
        Map<String, AttributeValue> expressionValues = null;
        String conditionExpressionString = null;
        if (!filteredAttributeValues.isEmpty()) {
            Expression fullUpdateExpression = UpdateItemOperation.generateUpdateExpression(filteredAttributeValues, tableMetadata);
            expressionNames = fullUpdateExpression.expressionNames();
            expressionValues = fullUpdateExpression.expressionValues();
            requestBuilder = requestBuilder.updateExpression(fullUpdateExpression.expression());
        }
        if (transformation != null && transformation.additionalConditionalExpression() != null) {
            expressionNames = Expression.joinNames(expressionNames, transformation.additionalConditionalExpression().expressionNames());
            expressionValues = Expression.joinValues(expressionValues, transformation.additionalConditionalExpression().expressionValues());
            conditionExpressionString = transformation.additionalConditionalExpression().expression();
        }
        if (this.request.conditionExpression() != null) {
            expressionNames = Expression.joinNames(expressionNames, this.request.conditionExpression().expressionNames());
            expressionValues = Expression.joinValues(expressionValues, this.request.conditionExpression().expressionValues());
            conditionExpressionString = Expression.joinExpressions(conditionExpressionString, this.request.conditionExpression().expression(), " AND ");
        }
        if (expressionNames != null && !expressionNames.isEmpty()) {
            requestBuilder = requestBuilder.expressionAttributeNames(expressionNames);
        }
        if (expressionValues != null && !expressionValues.isEmpty()) {
            requestBuilder = requestBuilder.expressionAttributeValues(expressionValues);
        }
        return requestBuilder.conditionExpression(conditionExpressionString);
    }
}

