/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.enhanced.dynamodb.Expression;
import software.amazon.awssdk.enhanced.dynamodb.NestedAttributeName;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.utils.Validate;

@SdkPublicApi
public final class ScanEnhancedRequest {
    private final Map<String, AttributeValue> exclusiveStartKey;
    private final Integer limit;
    private final Boolean consistentRead;
    private final Expression filterExpression;
    private final List<NestedAttributeName> attributesToProject;

    private ScanEnhancedRequest(Builder builder) {
        this.exclusiveStartKey = builder.exclusiveStartKey;
        this.limit = builder.limit;
        this.consistentRead = builder.consistentRead;
        this.filterExpression = builder.filterExpression;
        this.attributesToProject = builder.attributesToProject != null ? Collections.unmodifiableList(builder.attributesToProject) : null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return ScanEnhancedRequest.builder().exclusiveStartKey(this.exclusiveStartKey).limit(this.limit).consistentRead(this.consistentRead).filterExpression(this.filterExpression).addNestedAttributesToProject(this.attributesToProject);
    }

    public Map<String, AttributeValue> exclusiveStartKey() {
        return this.exclusiveStartKey;
    }

    public Integer limit() {
        return this.limit;
    }

    public Boolean consistentRead() {
        return this.consistentRead;
    }

    public Expression filterExpression() {
        return this.filterExpression;
    }

    public List<String> attributesToProject() {
        return this.attributesToProject != null ? this.attributesToProject.stream().map(item -> String.join((CharSequence)".", item.elements())).collect(Collectors.toList()) : null;
    }

    public List<NestedAttributeName> nestedAttributesToProject() {
        return this.attributesToProject;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScanEnhancedRequest scan = (ScanEnhancedRequest)o;
        if (this.exclusiveStartKey != null ? !this.exclusiveStartKey.equals(scan.exclusiveStartKey) : scan.exclusiveStartKey != null) {
            return false;
        }
        if (this.limit != null ? !this.limit.equals(scan.limit) : scan.limit != null) {
            return false;
        }
        if (this.consistentRead != null ? !this.consistentRead.equals(scan.consistentRead) : scan.consistentRead != null) {
            return false;
        }
        if (this.attributesToProject != null ? !this.attributesToProject.equals(scan.attributesToProject) : scan.attributesToProject != null) {
            return false;
        }
        return this.filterExpression != null ? this.filterExpression.equals(scan.filterExpression) : scan.filterExpression == null;
    }

    public int hashCode() {
        int result = this.exclusiveStartKey != null ? this.exclusiveStartKey.hashCode() : 0;
        result = 31 * result + (this.limit != null ? this.limit.hashCode() : 0);
        result = 31 * result + (this.consistentRead != null ? this.consistentRead.hashCode() : 0);
        result = 31 * result + (this.filterExpression != null ? this.filterExpression.hashCode() : 0);
        result = 31 * result + (this.attributesToProject != null ? this.attributesToProject.hashCode() : 0);
        return result;
    }

    public static final class Builder {
        private Map<String, AttributeValue> exclusiveStartKey;
        private Integer limit;
        private Boolean consistentRead;
        private Expression filterExpression;
        private List<NestedAttributeName> attributesToProject;

        private Builder() {
        }

        public Builder exclusiveStartKey(Map<String, AttributeValue> exclusiveStartKey) {
            this.exclusiveStartKey = exclusiveStartKey != null ? new HashMap<String, AttributeValue>(exclusiveStartKey) : null;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder consistentRead(Boolean consistentRead) {
            this.consistentRead = consistentRead;
            return this;
        }

        public Builder filterExpression(Expression filterExpression) {
            this.filterExpression = filterExpression;
            return this;
        }

        public Builder attributesToProject(Collection<String> attributesToProject) {
            if (this.attributesToProject != null) {
                this.attributesToProject.clear();
            }
            if (attributesToProject != null) {
                this.addNestedAttributesToProject(new ArrayList<String>(attributesToProject).stream().map(NestedAttributeName::create).collect(Collectors.toList()));
            }
            return this;
        }

        public Builder attributesToProject(String ... attributesToProject) {
            return this.attributesToProject(Arrays.asList(attributesToProject));
        }

        public Builder addAttributeToProject(String attributeToProject) {
            if (attributeToProject != null) {
                this.addNestedAttributesToProject(NestedAttributeName.create(attributeToProject));
            }
            return this;
        }

        public Builder addNestedAttributesToProject(Collection<NestedAttributeName> nestedAttributeNames) {
            if (nestedAttributeNames != null) {
                Validate.noNullElements(nestedAttributeNames, (String)"nestedAttributeNames list must not contain null elements", (Object[])new Object[0]);
                if (this.attributesToProject == null) {
                    this.attributesToProject = new ArrayList<NestedAttributeName>(nestedAttributeNames);
                } else {
                    this.attributesToProject.addAll(nestedAttributeNames);
                }
            }
            return this;
        }

        public Builder addNestedAttributesToProject(NestedAttributeName ... nestedAttributeNames) {
            this.addNestedAttributesToProject(Arrays.asList(nestedAttributeNames));
            return this;
        }

        public Builder addNestedAttributeToProject(NestedAttributeName nestedAttributeName) {
            if (nestedAttributeName != null) {
                this.addNestedAttributesToProject(Arrays.asList(nestedAttributeName));
            }
            return this;
        }

        public ScanEnhancedRequest build() {
            return new ScanEnhancedRequest(this);
        }
    }
}

