/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.mapper;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.AttributeValueType;
import software.amazon.awssdk.enhanced.dynamodb.internal.AttributeValues;
import software.amazon.awssdk.enhanced.dynamodb.internal.EnhancedClientUtils;
import software.amazon.awssdk.enhanced.dynamodb.internal.mapper.AttributeType;
import software.amazon.awssdk.enhanced.dynamodb.mapper.StaticAttribute;
import software.amazon.awssdk.enhanced.dynamodb.mapper.StaticTableMetadata;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
public final class ResolvedStaticAttribute<T> {
    private final String attributeName;
    private final Function<T, AttributeValue> getAttributeMethod;
    private final BiConsumer<T, AttributeValue> updateItemMethod;
    private final StaticTableMetadata tableMetadata;
    private final AttributeValueType attributeValueType;

    private ResolvedStaticAttribute(String attributeName, Function<T, AttributeValue> getAttributeMethod, BiConsumer<T, AttributeValue> updateItemMethod, StaticTableMetadata tableMetadata, AttributeValueType attributeValueType) {
        this.attributeName = attributeName;
        this.getAttributeMethod = getAttributeMethod;
        this.updateItemMethod = updateItemMethod;
        this.tableMetadata = tableMetadata;
        this.attributeValueType = attributeValueType;
    }

    public static <T, R> ResolvedStaticAttribute<T> create(StaticAttribute<T, R> staticAttribute, AttributeType<R> attributeType) {
        Function<Object, AttributeValue> getAttributeValueWithTransform = item -> {
            Object value = staticAttribute.getter().apply(item);
            return value == null ? AttributeValues.nullAttributeValue() : attributeType.objectToAttributeValue(value);
        };
        BiConsumer<Object, AttributeValue> updateItemWithTransform = (item, attributeValue) -> {
            if (EnhancedClientUtils.isNullAttributeValue(attributeValue)) {
                return;
            }
            Object value = attributeType.attributeValueToObject((AttributeValue)attributeValue);
            if (value != null) {
                staticAttribute.setter().accept(item, value);
            }
        };
        StaticTableMetadata.Builder tableMetadataBuilder = StaticTableMetadata.builder();
        staticAttribute.tags().forEach(tag -> tag.modifyMetadata(staticAttribute.name(), attributeType.attributeValueType()).accept(tableMetadataBuilder));
        return new ResolvedStaticAttribute<Object>(staticAttribute.name(), getAttributeValueWithTransform, updateItemWithTransform, tableMetadataBuilder.build(), attributeType.attributeValueType());
    }

    public <R> ResolvedStaticAttribute<R> transform(Function<R, T> transform, Consumer<R> createComponent) {
        return new ResolvedStaticAttribute<Object>(this.attributeName, item -> {
            Object otherItem = transform.apply(item);
            return otherItem == null ? AttributeValues.nullAttributeValue() : this.getAttributeMethod.apply(otherItem);
        }, (item, value) -> {
            if (createComponent != null) {
                createComponent.accept(item);
            }
            this.updateItemMethod.accept(transform.apply(item), (AttributeValue)value);
        }, this.tableMetadata, this.attributeValueType);
    }

    public String attributeName() {
        return this.attributeName;
    }

    public Function<T, AttributeValue> attributeGetterMethod() {
        return this.getAttributeMethod;
    }

    public BiConsumer<T, AttributeValue> updateItemMethod() {
        return this.updateItemMethod;
    }

    public StaticTableMetadata tableMetadata() {
        return this.tableMetadata;
    }
}

