/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.mapper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverterProvider;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.internal.EnhancedClientUtils;
import software.amazon.awssdk.enhanced.dynamodb.internal.mapper.ResolvedStaticAttribute;
import software.amazon.awssdk.enhanced.dynamodb.mapper.StaticAttribute;
import software.amazon.awssdk.enhanced.dynamodb.mapper.StaticTableMetadata;
import software.amazon.awssdk.enhanced.dynamodb.mapper.StaticTableTag;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkPublicApi
public final class StaticTableSchema<T>
implements TableSchema<T> {
    private static final AttributeConverterProvider DEFAULT_ATTRIBUTE_CONVERTER = AttributeConverterProvider.defaultProvider();
    private final List<ResolvedStaticAttribute<T>> attributeMappers;
    private final Supplier<T> newItemSupplier;
    private final Map<String, ResolvedStaticAttribute<T>> indexedMappers;
    private final StaticTableMetadata tableMetadata;
    private final EnhancedType<T> itemType;
    private final AttributeConverterProvider attributeConverterProvider;

    private StaticTableSchema(Builder<T> builder) {
        StaticTableMetadata.Builder tableMetadataBuilder = StaticTableMetadata.builder();
        this.attributeConverterProvider = ((Builder)builder).attributeConverterProvider != null ? ((Builder)builder).attributeConverterProvider : DEFAULT_ATTRIBUTE_CONVERTER;
        Stream attributesStream = ((Builder)builder).attributes == null ? Stream.empty() : ((Builder)builder).attributes.stream().map(a -> a.resolve(this.attributeConverterProvider));
        ArrayList mutableAttributeMappers = new ArrayList();
        HashMap mutableIndexedMappers = new HashMap();
        Stream.concat(attributesStream, ((Builder)builder).additionalAttributes.stream()).forEach(resolvedAttribute -> {
            String attributeName = resolvedAttribute.attributeName();
            if (mutableIndexedMappers.containsKey(attributeName)) {
                throw new IllegalArgumentException("Attempt to add an attribute to a mapper that already has one with the same name. [Attribute name: " + attributeName + "]");
            }
            mutableAttributeMappers.add(resolvedAttribute);
            mutableIndexedMappers.put(attributeName, resolvedAttribute);
            tableMetadataBuilder.mergeWith(resolvedAttribute.tableMetadata());
        });
        if (((Builder)builder).tags != null) {
            ((Builder)builder).tags.forEach(staticTableTag -> staticTableTag.modifyMetadata().accept(tableMetadataBuilder));
        }
        this.attributeMappers = Collections.unmodifiableList(mutableAttributeMappers);
        this.indexedMappers = Collections.unmodifiableMap(mutableIndexedMappers);
        this.newItemSupplier = ((Builder)builder).newItemSupplier;
        this.tableMetadata = tableMetadataBuilder.build();
        this.itemType = EnhancedType.of(((Builder)builder).itemClass);
    }

    public static <T> Builder<T> builder(Class<T> itemClass) {
        return new Builder(itemClass);
    }

    @Override
    public StaticTableMetadata tableMetadata() {
        return this.tableMetadata;
    }

    @Override
    public T mapToItem(Map<String, AttributeValue> attributeMap) {
        Object item = null;
        for (Map.Entry<String, AttributeValue> entry : attributeMap.entrySet()) {
            ResolvedStaticAttribute<T> attributeMapper;
            String key = entry.getKey();
            AttributeValue value = entry.getValue();
            if (EnhancedClientUtils.isNullAttributeValue(value) || (attributeMapper = this.indexedMappers.get(key)) == null) continue;
            if (item == null) {
                item = this.constructNewItem();
            }
            attributeMapper.updateItemMethod().accept(item, value);
        }
        return item;
    }

    @Override
    public Map<String, AttributeValue> itemToMap(T item, boolean ignoreNulls) {
        HashMap attributeValueMap = new HashMap();
        this.attributeMappers.forEach(attributeMapper -> {
            String attributeKey = attributeMapper.attributeName();
            AttributeValue attributeValue = attributeMapper.attributeGetterMethod().apply(item);
            if (!ignoreNulls || !EnhancedClientUtils.isNullAttributeValue(attributeValue)) {
                attributeValueMap.put(attributeKey, attributeValue);
            }
        });
        return Collections.unmodifiableMap(attributeValueMap);
    }

    @Override
    public Map<String, AttributeValue> itemToMap(T item, Collection<String> attributes) {
        HashMap attributeValueMap = new HashMap();
        attributes.forEach(key -> {
            AttributeValue attributeValue = this.attributeValue(item, (String)key);
            if (attributeValue == null || !EnhancedClientUtils.isNullAttributeValue(attributeValue)) {
                attributeValueMap.put(key, attributeValue);
            }
        });
        return Collections.unmodifiableMap(attributeValueMap);
    }

    @Override
    public AttributeValue attributeValue(T item, String key) {
        ResolvedStaticAttribute<T> attributeMapper = this.indexedMappers.get(key);
        if (attributeMapper == null) {
            throw new IllegalArgumentException(String.format("TableSchema does not know how to retrieve requested attribute '%s' from mapped object.", key));
        }
        AttributeValue attributeValue = attributeMapper.attributeGetterMethod().apply(item);
        return EnhancedClientUtils.isNullAttributeValue(attributeValue) ? null : attributeValue;
    }

    @Override
    public EnhancedType<T> itemType() {
        return this.itemType;
    }

    public AttributeConverterProvider attributeConverterProvider() {
        return this.attributeConverterProvider;
    }

    private T constructNewItem() {
        if (this.newItemSupplier == null) {
            throw new UnsupportedOperationException("An abstract TableSchema cannot be used to map a database record to a concrete object. Add a 'newItemSupplier' to the TableSchema to give it the ability to create mapped objects.");
        }
        return this.newItemSupplier.get();
    }

    public static final class Builder<T> {
        private final Class<T> itemClass;
        private final List<ResolvedStaticAttribute<T>> additionalAttributes = new ArrayList<ResolvedStaticAttribute<T>>();
        private List<StaticAttribute<T, ?>> attributes;
        private Supplier<T> newItemSupplier;
        private List<StaticTableTag> tags;
        private AttributeConverterProvider attributeConverterProvider;

        private Builder(Class<T> itemClass) {
            this.itemClass = itemClass;
        }

        public Builder<T> newItemSupplier(Supplier<T> newItemSupplier) {
            this.newItemSupplier = newItemSupplier;
            return this;
        }

        @SafeVarargs
        public final Builder<T> attributes(StaticAttribute<T, ?> ... staticAttributes) {
            this.attributes = Arrays.asList(staticAttributes);
            return this;
        }

        public Builder<T> attributes(Collection<StaticAttribute<T, ?>> staticAttributes) {
            this.attributes = new ArrayList(staticAttributes);
            return this;
        }

        public <R> Builder<T> addAttribute(EnhancedType<R> attributeType, Consumer<StaticAttribute.Builder<T, R>> staticAttribute) {
            StaticAttribute.Builder<T, R> builder = StaticAttribute.builder(this.itemClass, attributeType);
            staticAttribute.accept(builder);
            return this.addAttribute(builder.build());
        }

        public <R> Builder<T> addAttribute(Class<R> attributeClass, Consumer<StaticAttribute.Builder<T, R>> staticAttribute) {
            return this.addAttribute(EnhancedType.of(attributeClass), staticAttribute);
        }

        public Builder<T> addAttribute(StaticAttribute<T, ?> staticAttribute) {
            if (this.attributes == null) {
                this.attributes = new ArrayList();
            }
            this.attributes.add(staticAttribute);
            return this;
        }

        public <R> Builder<T> flatten(StaticTableSchema<R> otherTableSchema, Function<T, R> otherItemGetter, BiConsumer<T, R> otherItemSetter) {
            if (otherTableSchema.newItemSupplier == null) {
                throw new IllegalArgumentException("Cannot flatten an abstract StaticTableSchema. Add a 'newItemSupplier' to the other StaticTableSchema to make it concrete.");
            }
            Consumer<Object> composedObjectConstructor = parentObject -> {
                if (otherItemGetter.apply(parentObject) == null) {
                    Object compositeItem = otherTableSchema.newItemSupplier.get();
                    otherItemSetter.accept(parentObject, compositeItem);
                }
            };
            otherTableSchema.attributeMappers.stream().map(attribute -> attribute.transform(otherItemGetter, composedObjectConstructor)).forEach(this.additionalAttributes::add);
            return this;
        }

        public Builder<T> extend(StaticTableSchema<? super T> superTableSchema) {
            Stream<ResolvedStaticAttribute<ResolvedStaticAttribute>> attributeStream = Builder.upcastingTransformForAttributes(((StaticTableSchema)superTableSchema).attributeMappers);
            attributeStream.forEach(this.additionalAttributes::add);
            return this;
        }

        public Builder<T> tags(StaticTableTag ... staticTableTags) {
            this.tags = Arrays.asList(staticTableTags);
            return this;
        }

        public Builder<T> tags(Collection<StaticTableTag> staticTableTags) {
            this.tags = new ArrayList<StaticTableTag>(staticTableTags);
            return this;
        }

        public Builder<T> addTag(StaticTableTag staticTableTag) {
            if (this.tags == null) {
                this.tags = new ArrayList<StaticTableTag>();
            }
            this.tags.add(staticTableTag);
            return this;
        }

        public Builder<T> attributeConverterProvider(AttributeConverterProvider attributeConverterProvider) {
            this.attributeConverterProvider = attributeConverterProvider;
            return this;
        }

        public StaticTableSchema<T> build() {
            return new StaticTableSchema(this);
        }

        private static <T extends R, R> Stream<ResolvedStaticAttribute<T>> upcastingTransformForAttributes(Collection<ResolvedStaticAttribute<R>> superAttributes) {
            return superAttributes.stream().map(attribute -> attribute.transform(x -> x, null));
        }
    }
}

