/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute;

import java.time.Instant;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.AttributeValueType;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.TimeConversion;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.EnhancedAttributeValue;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
@ThreadSafe
@Immutable
public final class InstantAsIntegerAttributeConverter
implements AttributeConverter<Instant> {
    private InstantAsIntegerAttributeConverter() {
    }

    public static InstantAsIntegerAttributeConverter create() {
        return new InstantAsIntegerAttributeConverter();
    }

    @Override
    public EnhancedType<Instant> type() {
        return EnhancedType.of(Instant.class);
    }

    @Override
    public AttributeValueType attributeValueType() {
        return AttributeValueType.N;
    }

    @Override
    public AttributeValue transformFrom(Instant input) {
        return TimeConversion.toIntegerAttributeValue(input);
    }

    @Override
    public Instant transformTo(AttributeValue input) {
        if (input.n() != null) {
            return TimeConversion.instantFromAttributeValue(EnhancedAttributeValue.fromNumber(input.n()));
        }
        return TimeConversion.instantFromAttributeValue(EnhancedAttributeValue.fromAttributeValue(input));
    }
}

