/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.operations;

import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbEnhancedClientExtension;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.internal.TransformIterable;
import software.amazon.awssdk.enhanced.dynamodb.internal.TransformPublisher;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.OperationContext;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;

@SdkInternalApi
public interface PaginatedOperation<ItemT, RequestT, ResponseT, ResultT> {
    public RequestT generateRequest(TableSchema<ItemT> var1, OperationContext var2, DynamoDbEnhancedClientExtension var3);

    public Function<RequestT, SdkIterable<ResponseT>> serviceCall(DynamoDbClient var1);

    public Function<RequestT, SdkPublisher<ResponseT>> asyncServiceCall(DynamoDbAsyncClient var1);

    public ResultT transformResponse(ResponseT var1, TableSchema<ItemT> var2, OperationContext var3, DynamoDbEnhancedClientExtension var4);

    default public SdkIterable<ResultT> execute(TableSchema<ItemT> tableSchema, OperationContext context, DynamoDbEnhancedClientExtension extension, DynamoDbClient dynamoDbClient) {
        RequestT request = this.generateRequest(tableSchema, context, extension);
        SdkIterable<ResponseT> response = this.serviceCall(dynamoDbClient).apply(request);
        return TransformIterable.of(response, r -> this.transformResponse(r, tableSchema, context, extension));
    }

    default public SdkPublisher<ResultT> executeAsync(TableSchema<ItemT> tableSchema, OperationContext context, DynamoDbEnhancedClientExtension extension, DynamoDbAsyncClient dynamoDbAsyncClient) {
        RequestT request = this.generateRequest(tableSchema, context, extension);
        SdkPublisher<ResponseT> response = this.asyncServiceCall(dynamoDbAsyncClient).apply(request);
        return TransformPublisher.of(response, r -> this.transformResponse(r, tableSchema, context, extension));
    }
}

