/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute;

import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.AttributeValueType;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.PrimitiveConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.TypeConvertingVisitor;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.EnhancedAttributeValue;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.ShortStringConverter;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
@ThreadSafe
@Immutable
public final class ShortAttributeConverter
implements AttributeConverter<Short>,
PrimitiveConverter<Short> {
    public static final ShortStringConverter STRING_CONVERTER = ShortStringConverter.create();

    public static ShortAttributeConverter create() {
        return new ShortAttributeConverter();
    }

    @Override
    public EnhancedType<Short> type() {
        return EnhancedType.of(Short.class);
    }

    @Override
    public AttributeValueType attributeValueType() {
        return AttributeValueType.N;
    }

    @Override
    public AttributeValue transformFrom(Short input) {
        return EnhancedAttributeValue.fromNumber(STRING_CONVERTER.toString(input)).toAttributeValue();
    }

    @Override
    public Short transformTo(AttributeValue input) {
        if (input.n() != null) {
            return EnhancedAttributeValue.fromNumber(input.n()).convert(Visitor.INSTANCE);
        }
        return EnhancedAttributeValue.fromAttributeValue(input).convert(Visitor.INSTANCE);
    }

    @Override
    public EnhancedType<Short> primitiveType() {
        return EnhancedType.of(Short.TYPE);
    }

    private static final class Visitor
    extends TypeConvertingVisitor<Short> {
        private static final Visitor INSTANCE = new Visitor();

        private Visitor() {
            super(Short.class, ShortAttributeConverter.class);
        }

        @Override
        public Short convertString(String value) {
            return STRING_CONVERTER.fromString(value);
        }

        @Override
        public Short convertNumber(String value) {
            return STRING_CONVERTER.fromString(value);
        }
    }
}

