/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute;

import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.AttributeValueType;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.PrimitiveConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.TypeConvertingVisitor;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.EnhancedAttributeValue;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.LongStringConverter;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
@ThreadSafe
@Immutable
public final class LongAttributeConverter
implements AttributeConverter<Long>,
PrimitiveConverter<Long> {
    private static final Visitor VISITOR = new Visitor();
    private static final LongStringConverter STRING_CONVERTER = LongStringConverter.create();

    private LongAttributeConverter() {
    }

    @Override
    public EnhancedType<Long> type() {
        return EnhancedType.of(Long.class);
    }

    @Override
    public AttributeValueType attributeValueType() {
        return AttributeValueType.N;
    }

    public static LongAttributeConverter create() {
        return new LongAttributeConverter();
    }

    @Override
    public AttributeValue transformFrom(Long input) {
        return EnhancedAttributeValue.fromNumber(STRING_CONVERTER.toString(input)).toAttributeValue();
    }

    @Override
    public Long transformTo(AttributeValue input) {
        if (input.n() != null) {
            return EnhancedAttributeValue.fromNumber(input.n()).convert(VISITOR);
        }
        return EnhancedAttributeValue.fromAttributeValue(input).convert(VISITOR);
    }

    @Override
    public EnhancedType<Long> primitiveType() {
        return EnhancedType.of(Long.TYPE);
    }

    private static final class Visitor
    extends TypeConvertingVisitor<Long> {
        private Visitor() {
            super(Long.class, LongAttributeConverter.class);
        }

        @Override
        public Long convertString(String value) {
            return STRING_CONVERTER.fromString(value);
        }

        @Override
        public Long convertNumber(String value) {
            return STRING_CONVERTER.fromString(value);
        }
    }
}

