/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.extensions;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbEnhancedClientExtension;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbExtensionContext;
import software.amazon.awssdk.enhanced.dynamodb.Expression;
import software.amazon.awssdk.enhanced.dynamodb.extensions.ReadModification;
import software.amazon.awssdk.enhanced.dynamodb.extensions.WriteModification;
import software.amazon.awssdk.enhanced.dynamodb.internal.extensions.DefaultDynamoDbExtensionContext;

@SdkInternalApi
public final class ChainExtension
implements DynamoDbEnhancedClientExtension {
    private final Deque<DynamoDbEnhancedClientExtension> extensionChain;

    private ChainExtension(List<DynamoDbEnhancedClientExtension> extensions) {
        this.extensionChain = new ArrayDeque<DynamoDbEnhancedClientExtension>(extensions);
    }

    public static ChainExtension create(DynamoDbEnhancedClientExtension ... extensions) {
        return new ChainExtension(Arrays.asList(extensions));
    }

    public static ChainExtension create(List<DynamoDbEnhancedClientExtension> extensions) {
        return new ChainExtension(extensions);
    }

    @Override
    public WriteModification beforeWrite(DynamoDbExtensionContext.BeforeWrite context) {
        AtomicReference transformedItem = new AtomicReference();
        AtomicReference conditionalExpression = new AtomicReference();
        this.extensionChain.forEach(extension -> {
            Map itemToTransform = transformedItem.get() == null ? context.items() : (Map)transformedItem.get();
            DefaultDynamoDbExtensionContext beforeWrite = DefaultDynamoDbExtensionContext.builder().items(itemToTransform).operationContext(context.operationContext()).tableMetadata(context.tableMetadata()).build();
            WriteModification writeModification = extension.beforeWrite(beforeWrite);
            if (writeModification.transformedItem() != null) {
                transformedItem.set(writeModification.transformedItem());
            }
            if (writeModification.additionalConditionalExpression() != null) {
                if (conditionalExpression.get() == null) {
                    conditionalExpression.set(writeModification.additionalConditionalExpression());
                } else {
                    conditionalExpression.set(Expression.join((Expression)conditionalExpression.get(), writeModification.additionalConditionalExpression(), " AND "));
                }
            }
        });
        return WriteModification.builder().transformedItem((Map)transformedItem.get()).additionalConditionalExpression((Expression)conditionalExpression.get()).build();
    }

    @Override
    public ReadModification afterRead(DynamoDbExtensionContext.AfterRead context) {
        AtomicReference transformedItem = new AtomicReference();
        this.extensionChain.descendingIterator().forEachRemaining(extension -> {
            Map itemToTransform = transformedItem.get() == null ? context.items() : (Map)transformedItem.get();
            DefaultDynamoDbExtensionContext afterRead = DefaultDynamoDbExtensionContext.builder().items(itemToTransform).operationContext(context.operationContext()).tableMetadata(context.tableMetadata()).build();
            ReadModification readModification = extension.afterRead(afterRead);
            if (readModification.transformedItem() != null) {
                transformedItem.set(readModification.transformedItem());
            }
        });
        return ReadModification.builder().transformedItem((Map)transformedItem.get()).build();
    }
}

