/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.TypeToken;
import software.amazon.awssdk.enhanced.dynamodb.mapper.AttributeValueType;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
public class DocumentAttributeConverter<T>
implements AttributeConverter<T> {
    private final TableSchema<T> tableSchema;
    private final TypeToken<T> typeToken;

    private DocumentAttributeConverter(TableSchema<T> tableSchema, TypeToken<T> typeToken) {
        this.tableSchema = tableSchema;
        this.typeToken = typeToken;
    }

    public static <T> DocumentAttributeConverter create(TableSchema<T> tableSchema, TypeToken<T> typeToken) {
        return new DocumentAttributeConverter<T>(tableSchema, typeToken);
    }

    @Override
    public AttributeValue transformFrom(T input) {
        return (AttributeValue)AttributeValue.builder().m(this.tableSchema.itemToMap(input, false)).build();
    }

    @Override
    public T transformTo(AttributeValue input) {
        return this.tableSchema.mapToItem(input.m());
    }

    @Override
    public AttributeValueType attributeValueType() {
        return AttributeValueType.M;
    }

    @Override
    public TypeToken<T> type() {
        return this.typeToken;
    }
}

