/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute;

import java.math.BigInteger;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.TypeToken;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.TypeConvertingVisitor;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.EnhancedAttributeValue;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.BigIntegerStringConverter;
import software.amazon.awssdk.enhanced.dynamodb.mapper.AttributeValueType;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
@ThreadSafe
@Immutable
public final class BigIntegerAttributeConverter
implements AttributeConverter<BigInteger> {
    private static final Visitor VISITOR = new Visitor();
    private static final BigIntegerStringConverter STRING_CONVERTER = BigIntegerStringConverter.create();

    private BigIntegerAttributeConverter() {
    }

    public static BigIntegerAttributeConverter create() {
        return new BigIntegerAttributeConverter();
    }

    @Override
    public TypeToken<BigInteger> type() {
        return TypeToken.of(BigInteger.class);
    }

    @Override
    public AttributeValueType attributeValueType() {
        return AttributeValueType.N;
    }

    @Override
    public AttributeValue transformFrom(BigInteger input) {
        return EnhancedAttributeValue.fromNumber(STRING_CONVERTER.toString(input)).toAttributeValue();
    }

    @Override
    public BigInteger transformTo(AttributeValue input) {
        if (input.n() != null) {
            return EnhancedAttributeValue.fromNumber(input.n()).convert(VISITOR);
        }
        return EnhancedAttributeValue.fromAttributeValue(input).convert(VISITOR);
    }

    private static final class Visitor
    extends TypeConvertingVisitor<BigInteger> {
        private Visitor() {
            super(BigInteger.class, BigIntegerAttributeConverter.class);
        }

        @Override
        public BigInteger convertString(String value) {
            return STRING_CONVERTER.fromString(value);
        }

        @Override
        public BigInteger convertNumber(String value) {
            return STRING_CONVERTER.fromString(value);
        }
    }
}

