/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.string;

import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.TypeToken;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.PrimitiveConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.StringConverter;

@SdkInternalApi
@ThreadSafe
@Immutable
public class LongStringConverter
implements StringConverter<Long>,
PrimitiveConverter<Long> {
    private LongStringConverter() {
    }

    public static LongStringConverter create() {
        return new LongStringConverter();
    }

    @Override
    public TypeToken<Long> type() {
        return TypeToken.of(Long.class);
    }

    @Override
    public TypeToken<Long> primitiveType() {
        return TypeToken.of(Long.TYPE);
    }

    @Override
    public Long fromString(String string) {
        return Long.valueOf(string);
    }
}

