/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute;

import java.time.ZonedDateTime;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.TypeToken;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.TimeConversion;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.EnhancedAttributeValue;
import software.amazon.awssdk.enhanced.dynamodb.mapper.AttributeValueType;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
@ThreadSafe
@Immutable
public final class ZonedDateTimeAsStringAttributeConverter
implements AttributeConverter<ZonedDateTime> {
    public static ZonedDateTimeAsStringAttributeConverter create() {
        return new ZonedDateTimeAsStringAttributeConverter();
    }

    @Override
    public TypeToken<ZonedDateTime> type() {
        return TypeToken.of(ZonedDateTime.class);
    }

    @Override
    public AttributeValueType attributeValueType() {
        return AttributeValueType.S;
    }

    @Override
    public AttributeValue transformFrom(ZonedDateTime input) {
        return TimeConversion.toStringAttributeValue(input).toAttributeValue();
    }

    @Override
    public ZonedDateTime transformTo(AttributeValue input) {
        return TimeConversion.zonedDateTimeFromAttributeValue(EnhancedAttributeValue.fromAttributeValue(input));
    }
}

