/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.TypeToken;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.TypeConvertingVisitor;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.EnhancedAttributeValue;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.BooleanStringConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.ByteArrayStringConverter;
import software.amazon.awssdk.enhanced.dynamodb.mapper.AttributeValueType;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
@ThreadSafe
@Immutable
public final class StringAttributeConverter
implements AttributeConverter<String> {
    public static StringAttributeConverter create() {
        return new StringAttributeConverter();
    }

    @Override
    public TypeToken<String> type() {
        return TypeToken.of(String.class);
    }

    @Override
    public AttributeValueType attributeValueType() {
        return AttributeValueType.S;
    }

    @Override
    public AttributeValue transformFrom(String input) {
        return EnhancedAttributeValue.fromString(input).toAttributeValue();
    }

    @Override
    public String transformTo(AttributeValue input) {
        return EnhancedAttributeValue.fromAttributeValue(input).convert(Visitor.INSTANCE);
    }

    private static final class Visitor
    extends TypeConvertingVisitor<String> {
        private static final Visitor INSTANCE = new Visitor();

        private Visitor() {
            super(String.class, StringAttributeConverter.class);
        }

        @Override
        public String convertString(String value) {
            return value;
        }

        @Override
        public String convertNumber(String value) {
            return value;
        }

        @Override
        public String convertBytes(SdkBytes value) {
            return ByteArrayStringConverter.create().toString(value.asByteArray());
        }

        @Override
        public String convertBoolean(Boolean value) {
            return BooleanStringConverter.create().toString(value);
        }

        @Override
        public String convertSetOfStrings(List<String> value) {
            return value.toString();
        }

        @Override
        public String convertSetOfNumbers(List<String> value) {
            return value.toString();
        }

        @Override
        public String convertSetOfBytes(List<SdkBytes> value) {
            return value.stream().map(this::convertBytes).collect(Collectors.joining(",", "[", "]"));
        }

        @Override
        public String convertMap(Map<String, EnhancedAttributeValue> value) {
            BinaryOperator throwingMerger = (l, r) -> {
                throw new IllegalStateException();
            };
            return value.entrySet().stream().collect(Collectors.toMap(i -> (String)i.getKey(), i -> (String)this.convert((EnhancedAttributeValue)i.getValue()), throwingMerger, LinkedHashMap::new)).toString();
        }

        @Override
        public String convertListOfAttributeValues(List<EnhancedAttributeValue> value) {
            return value.stream().map(this::convert).collect(Collectors.toList()).toString();
        }
    }
}

