/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute;

import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.TypeToken;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.ConverterUtils;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.PrimitiveConverter;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.TypeConvertingVisitor;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.EnhancedAttributeValue;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.string.DoubleStringConverter;
import software.amazon.awssdk.enhanced.dynamodb.mapper.AttributeValueType;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
@ThreadSafe
@Immutable
public final class DoubleAttributeConverter
implements AttributeConverter<Double>,
PrimitiveConverter<Double> {
    private static final Visitor VISITOR = new Visitor();
    private static final DoubleStringConverter STRING_CONVERTER = DoubleStringConverter.create();

    private DoubleAttributeConverter() {
    }

    public static DoubleAttributeConverter create() {
        return new DoubleAttributeConverter();
    }

    @Override
    public TypeToken<Double> type() {
        return TypeToken.of(Double.class);
    }

    @Override
    public AttributeValueType attributeValueType() {
        return AttributeValueType.N;
    }

    @Override
    public AttributeValue transformFrom(Double input) {
        ConverterUtils.validateDouble(input);
        return EnhancedAttributeValue.fromNumber(STRING_CONVERTER.toString(input)).toAttributeValue();
    }

    @Override
    public Double transformTo(AttributeValue input) {
        Double result = input.n() != null ? EnhancedAttributeValue.fromNumber(input.n()).convert(VISITOR) : EnhancedAttributeValue.fromAttributeValue(input).convert(VISITOR);
        ConverterUtils.validateDouble(result);
        return result;
    }

    @Override
    public TypeToken<Double> primitiveType() {
        return TypeToken.of(Double.TYPE);
    }

    private static final class Visitor
    extends TypeConvertingVisitor<Double> {
        private Visitor() {
            super(Double.class, DoubleAttributeConverter.class);
        }

        @Override
        public Double convertString(String value) {
            return STRING_CONVERTER.fromString(value);
        }

        @Override
        public Double convertNumber(String value) {
            return STRING_CONVERTER.fromString(value);
        }
    }
}

