/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute;

import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.TypeToken;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.StringAttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.mapper.AttributeValueType;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
@ThreadSafe
@Immutable
public final class StringBuilderAttributeConverter
implements AttributeConverter<StringBuilder> {
    public static final StringAttributeConverter STRING_CONVERTER = StringAttributeConverter.create();

    public static StringBuilderAttributeConverter create() {
        return new StringBuilderAttributeConverter();
    }

    @Override
    public TypeToken<StringBuilder> type() {
        return TypeToken.of(StringBuilder.class);
    }

    @Override
    public AttributeValueType attributeValueType() {
        return AttributeValueType.S;
    }

    @Override
    public AttributeValue transformFrom(StringBuilder input) {
        return STRING_CONVERTER.transformFrom(input.toString());
    }

    @Override
    public StringBuilder transformTo(AttributeValue input) {
        return new StringBuilder(STRING_CONVERTER.transformTo(input));
    }
}

