/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute;

import java.time.OffsetDateTime;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.TypeToken;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.TimeConversion;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.EnhancedAttributeValue;
import software.amazon.awssdk.enhanced.dynamodb.mapper.AttributeValueType;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
@ThreadSafe
@Immutable
public final class OffsetDateTimeAsStringAttributeConverter
implements AttributeConverter<OffsetDateTime> {
    public static OffsetDateTimeAsStringAttributeConverter create() {
        return new OffsetDateTimeAsStringAttributeConverter();
    }

    @Override
    public TypeToken<OffsetDateTime> type() {
        return TypeToken.of(OffsetDateTime.class);
    }

    @Override
    public AttributeValueType attributeValueType() {
        return AttributeValueType.S;
    }

    @Override
    public AttributeValue transformFrom(OffsetDateTime input) {
        return TimeConversion.toStringAttributeValue(input).toAttributeValue();
    }

    @Override
    public OffsetDateTime transformTo(AttributeValue input) {
        return TimeConversion.offsetDateTimeFromAttributeValue(EnhancedAttributeValue.fromAttributeValue(input));
    }
}

