/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.TypeToken;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.EnhancedAttributeValue;
import software.amazon.awssdk.enhanced.dynamodb.mapper.AttributeValueType;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
public class EnumAttributeConverter<T extends Enum<T>>
implements AttributeConverter<T> {
    private final Class<T> enumClass;
    private final Map<String, T> enumValueMap;

    private EnumAttributeConverter(Class<T> enumClass) {
        this.enumClass = enumClass;
        LinkedHashMap mutableEnumValueMap = new LinkedHashMap();
        Arrays.stream(enumClass.getEnumConstants()).forEach(enumConstant -> mutableEnumValueMap.put(enumConstant.toString(), enumConstant));
        this.enumValueMap = Collections.unmodifiableMap(mutableEnumValueMap);
    }

    public static <T extends Enum<T>> EnumAttributeConverter<T> create(Class<T> enumClass) {
        return new EnumAttributeConverter<T>(enumClass);
    }

    @Override
    public AttributeValue transformFrom(T input) {
        return EnhancedAttributeValue.fromString(((Enum)input).toString()).toAttributeValue();
    }

    @Override
    public T transformTo(AttributeValue input) {
        EnhancedAttributeValue converted = EnhancedAttributeValue.fromString(input.s());
        Enum returnValue = (Enum)this.enumValueMap.get(converted.asString());
        if (returnValue == null) {
            throw new IllegalArgumentException(String.format("Unable to convert string value '%s' to enum type '%s'", converted.asString(), this.enumClass));
        }
        return (T)returnValue;
    }

    @Override
    public TypeToken<T> type() {
        return TypeToken.of(this.enumClass);
    }

    @Override
    public AttributeValueType attributeValueType() {
        return AttributeValueType.S;
    }
}

