/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.string;

import java.net.MalformedURLException;
import java.net.URL;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.TypeToken;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.StringConverter;

@SdkInternalApi
@ThreadSafe
@Immutable
public class UrlStringConverter
implements StringConverter<URL> {
    private UrlStringConverter() {
    }

    public static UrlStringConverter create() {
        return new UrlStringConverter();
    }

    @Override
    public TypeToken<URL> type() {
        return TypeToken.of(URL.class);
    }

    @Override
    public URL fromString(String string) {
        try {
            return new URL(string);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("URL format was incorrect: " + string, e);
        }
    }
}

