/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute;

import java.time.LocalDateTime;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.TypeToken;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.ConverterUtils;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.TypeConvertingVisitor;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.EnhancedAttributeValue;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.InstantAsIntegerAttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.mapper.AttributeValueType;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
@ThreadSafe
@Immutable
public final class LocalDateTimeAttributeConverter
implements AttributeConverter<LocalDateTime> {
    private static final Visitor VISITOR = new Visitor();

    public static LocalDateTimeAttributeConverter create() {
        return new LocalDateTimeAttributeConverter();
    }

    @Override
    public TypeToken<LocalDateTime> type() {
        return TypeToken.of(LocalDateTime.class);
    }

    @Override
    public AttributeValueType attributeValueType() {
        return AttributeValueType.N;
    }

    @Override
    public AttributeValue transformFrom(LocalDateTime input) {
        String value = "" + input.getYear() + ConverterUtils.padLeft2(input.getMonthValue()) + ConverterUtils.padLeft2(input.getDayOfMonth()) + ConverterUtils.padLeft2(input.getHour()) + ConverterUtils.padLeft2(input.getMinute()) + ConverterUtils.padLeft2(input.getSecond()) + (input.getNano() == 0 ? "" : "." + ConverterUtils.padLeft(9, input.getNano()));
        return EnhancedAttributeValue.fromNumber(value).toAttributeValue();
    }

    @Override
    public LocalDateTime transformTo(AttributeValue input) {
        if (input.n() != null) {
            return EnhancedAttributeValue.fromNumber(input.n()).convert(VISITOR);
        }
        return EnhancedAttributeValue.fromAttributeValue(input).convert(VISITOR);
    }

    private static final class Visitor
    extends TypeConvertingVisitor<LocalDateTime> {
        private Visitor() {
            super(LocalDateTime.class, InstantAsIntegerAttributeConverter.class);
        }

        @Override
        public LocalDateTime convertNumber(String value) {
            String[] splitOnDecimal = ConverterUtils.splitNumberOnDecimal(value);
            String[] chunkedDateTime = ConverterUtils.chunkWithLeftOverflow(splitOnDecimal[0], 2, 2, 2, 2, 2);
            int year = Integer.parseInt(chunkedDateTime[0]);
            return LocalDateTime.of(year, Integer.parseInt(chunkedDateTime[1]), Integer.parseInt(chunkedDateTime[2]), Integer.parseInt(chunkedDateTime[3]), Integer.parseInt(chunkedDateTime[4]), Integer.parseInt(chunkedDateTime[5]), Integer.parseInt(splitOnDecimal[1]));
        }
    }
}

