/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.model;

import java.util.HashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.enhanced.dynamodb.Expression;
import software.amazon.awssdk.enhanced.dynamodb.model.QueryConditional;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkPublicApi
public final class QueryEnhancedRequest {
    private final QueryConditional queryConditional;
    private final Map<String, AttributeValue> exclusiveStartKey;
    private final Boolean scanIndexForward;
    private final Integer limit;
    private final Boolean consistentRead;
    private final Expression filterExpression;

    private QueryEnhancedRequest(Builder builder) {
        this.queryConditional = builder.queryConditional;
        this.exclusiveStartKey = builder.exclusiveStartKey;
        this.scanIndexForward = builder.scanIndexForward;
        this.limit = builder.limit;
        this.consistentRead = builder.consistentRead;
        this.filterExpression = builder.filterExpression;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return QueryEnhancedRequest.builder().queryConditional(this.queryConditional).exclusiveStartKey(this.exclusiveStartKey).scanIndexForward(this.scanIndexForward).limit(this.limit).consistentRead(this.consistentRead).filterExpression(this.filterExpression);
    }

    public QueryConditional queryConditional() {
        return this.queryConditional;
    }

    public Map<String, AttributeValue> exclusiveStartKey() {
        return this.exclusiveStartKey;
    }

    public Boolean scanIndexForward() {
        return this.scanIndexForward;
    }

    public Integer limit() {
        return this.limit;
    }

    public Boolean consistentRead() {
        return this.consistentRead;
    }

    public Expression filterExpression() {
        return this.filterExpression;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryEnhancedRequest query = (QueryEnhancedRequest)o;
        if (this.queryConditional != null ? !this.queryConditional.equals(query.queryConditional) : query.queryConditional != null) {
            return false;
        }
        if (this.exclusiveStartKey != null ? !this.exclusiveStartKey.equals(query.exclusiveStartKey) : query.exclusiveStartKey != null) {
            return false;
        }
        if (this.scanIndexForward != null ? !this.scanIndexForward.equals(query.scanIndexForward) : query.scanIndexForward != null) {
            return false;
        }
        if (this.limit != null ? !this.limit.equals(query.limit) : query.limit != null) {
            return false;
        }
        if (this.consistentRead != null ? !this.consistentRead.equals(query.consistentRead) : query.consistentRead != null) {
            return false;
        }
        return this.filterExpression != null ? this.filterExpression.equals(query.filterExpression) : query.filterExpression == null;
    }

    public int hashCode() {
        int result = this.queryConditional != null ? this.queryConditional.hashCode() : 0;
        result = 31 * result + (this.exclusiveStartKey != null ? this.exclusiveStartKey.hashCode() : 0);
        result = 31 * result + (this.scanIndexForward != null ? this.scanIndexForward.hashCode() : 0);
        result = 31 * result + (this.limit != null ? this.limit.hashCode() : 0);
        result = 31 * result + (this.consistentRead != null ? this.consistentRead.hashCode() : 0);
        result = 31 * result + (this.filterExpression != null ? this.filterExpression.hashCode() : 0);
        return result;
    }

    public static final class Builder {
        private QueryConditional queryConditional;
        private Map<String, AttributeValue> exclusiveStartKey;
        private Boolean scanIndexForward;
        private Integer limit;
        private Boolean consistentRead;
        private Expression filterExpression;

        private Builder() {
        }

        public Builder queryConditional(QueryConditional queryConditional) {
            this.queryConditional = queryConditional;
            return this;
        }

        public Builder scanIndexForward(Boolean scanIndexForward) {
            this.scanIndexForward = scanIndexForward;
            return this;
        }

        public Builder exclusiveStartKey(Map<String, AttributeValue> exclusiveStartKey) {
            this.exclusiveStartKey = exclusiveStartKey != null ? new HashMap<String, AttributeValue>(exclusiveStartKey) : null;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder consistentRead(Boolean consistentRead) {
            this.consistentRead = consistentRead;
            return this;
        }

        public Builder filterExpression(Expression filterExpression) {
            this.filterExpression = filterExpression;
            return this;
        }

        public QueryEnhancedRequest build() {
            return new QueryEnhancedRequest(this);
        }
    }
}

