/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.mapper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.internal.EnhancedClientUtils;
import software.amazon.awssdk.enhanced.dynamodb.internal.mapper.StaticTableMetadata;
import software.amazon.awssdk.enhanced.dynamodb.mapper.Attribute;
import software.amazon.awssdk.enhanced.dynamodb.mapper.TableTag;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkPublicApi
public final class StaticTableSchema<T>
implements TableSchema<T> {
    private final List<Attribute<T>> attributeMappers;
    private final Supplier<T> newItemSupplier;
    private final Map<String, Attribute<T>> indexedMappers;
    private final StaticTableMetadata tableMetadata;

    private StaticTableSchema(List<Attribute<T>> attributeMappers, Supplier<T> newItemSupplier, StaticTableMetadata tableMetadata) {
        this.attributeMappers = attributeMappers;
        this.newItemSupplier = newItemSupplier;
        this.tableMetadata = tableMetadata;
        this.indexedMappers = Collections.unmodifiableMap(attributeMappers.stream().collect(Collectors.toMap(Attribute::attributeName, Function.identity())));
    }

    public static <T> Builder<T> builder(Class<? extends T> itemClass) {
        return new Builder();
    }

    @Override
    public StaticTableMetadata tableMetadata() {
        return this.tableMetadata;
    }

    @Override
    public T mapToItem(Map<String, AttributeValue> attributeMap) {
        AtomicReference item = new AtomicReference();
        attributeMap.forEach((key, value) -> {
            Attribute<T> attributeMapper;
            if (!EnhancedClientUtils.isNullAttributeValue(value) && (attributeMapper = this.indexedMappers.get(key)) != null) {
                if (item.get() == null) {
                    item.set(this.constructNewItem());
                }
                attributeMapper.updateItemMethod().accept(item.get(), (AttributeValue)value);
            }
        });
        return (T)item.get();
    }

    @Override
    public Map<String, AttributeValue> itemToMap(T item, boolean ignoreNulls) {
        HashMap attributeValueMap = new HashMap();
        this.attributeMappers.forEach(attributeMapper -> {
            String attributeKey = attributeMapper.attributeName();
            AttributeValue attributeValue = attributeMapper.attributeGetterMethod().apply(item);
            if (!ignoreNulls || !EnhancedClientUtils.isNullAttributeValue(attributeValue)) {
                attributeValueMap.put(attributeKey, attributeValue);
            }
        });
        return Collections.unmodifiableMap(attributeValueMap);
    }

    @Override
    public Map<String, AttributeValue> itemToMap(T item, Collection<String> attributes) {
        HashMap attributeValueMap = new HashMap();
        attributes.forEach(key -> {
            AttributeValue attributeValue = this.attributeValue(item, (String)key);
            if (attributeValue == null || !EnhancedClientUtils.isNullAttributeValue(attributeValue)) {
                attributeValueMap.put(key, attributeValue);
            }
        });
        return Collections.unmodifiableMap(attributeValueMap);
    }

    @Override
    public AttributeValue attributeValue(T item, String key) {
        Attribute<T> attributeMapper = this.indexedMappers.get(key);
        if (attributeMapper == null) {
            throw new IllegalArgumentException(String.format("TableSchema does not know how to retrieve requested attribute '%s' from mapped object.", key));
        }
        AttributeValue attributeValue = attributeMapper.attributeGetterMethod().apply(item);
        return EnhancedClientUtils.isNullAttributeValue(attributeValue) ? null : attributeValue;
    }

    private T constructNewItem() {
        if (this.newItemSupplier == null) {
            throw new UnsupportedOperationException("An abstract TableSchema cannot be used to map a database record to a concrete object. Add a 'newItemSupplier' to the TableSchema to give it the ability to create mapped objects.");
        }
        return this.newItemSupplier.get();
    }

    public static final class Builder<T> {
        private Supplier<T> newItemSupplier;
        private StaticTableMetadata.Builder tableMetadataBuilder = StaticTableMetadata.builder();
        private final List<Attribute<T>> mappedAttributes = new ArrayList<Attribute<T>>();
        private final Map<String, Attribute<T>> indexedMappers = new HashMap<String, Attribute<T>>();

        private Builder() {
        }

        public Builder<T> newItemSupplier(Supplier<T> newItemSupplier) {
            this.newItemSupplier = newItemSupplier;
            return this;
        }

        @SafeVarargs
        public final Builder<T> attributes(Attribute.AttributeSupplier<T> ... mappedAttributes) {
            Arrays.stream(mappedAttributes).map(Supplier::get).forEach(this::mergeAttribute);
            return this;
        }

        public Builder<T> attributes(Collection<Attribute.AttributeSupplier<T>> mappedAttributes) {
            mappedAttributes.stream().map(Supplier::get).forEach(this::mergeAttribute);
            return this;
        }

        public <R> Builder<T> flatten(StaticTableSchema<R> otherTableSchema, Function<T, R> otherItemGetter, BiConsumer<T, R> otherItemSetter) {
            if (otherTableSchema.newItemSupplier == null) {
                throw new IllegalArgumentException("Cannot flatten an abstract StaticTableSchema. Add a 'newItemSupplier' to the other StaticTableSchema to make it concrete.");
            }
            Consumer<Object> composedObjectConstructor = parentObject -> {
                if (otherItemGetter.apply(parentObject) == null) {
                    Object compositeItem = otherTableSchema.newItemSupplier.get();
                    otherItemSetter.accept(parentObject, compositeItem);
                }
            };
            otherTableSchema.attributeMappers.stream().map(attribute -> attribute.transform(otherItemGetter, composedObjectConstructor)).forEach(this::mergeAttribute);
            return this;
        }

        public Builder<T> extend(StaticTableSchema<? super T> superTableSchema) {
            Stream<Attribute<Attribute>> transformedAttributes = Builder.upcastingTransformForAttributes(((StaticTableSchema)superTableSchema).attributeMappers);
            transformedAttributes.forEach(this::mergeAttribute);
            return this;
        }

        public Builder<T> tagWith(TableTag ... tableTags) {
            Arrays.stream(tableTags).forEach(tableTag -> tableTag.setTableMetadata(this.tableMetadataBuilder));
            return this;
        }

        public StaticTableSchema<T> build() {
            return new StaticTableSchema(this.mappedAttributes, this.newItemSupplier, this.tableMetadataBuilder.build());
        }

        private void mergeAttribute(Attribute<T> attributeToMerge) {
            String attributeName = attributeToMerge.attributeName();
            if (this.indexedMappers.containsKey(attributeName)) {
                throw new IllegalArgumentException("Attempt to add an attribute to a mapper that already has one with the same name. [Attribute name: " + attributeName + "]");
            }
            this.mappedAttributes.add(attributeToMerge);
            this.indexedMappers.put(attributeName, attributeToMerge);
            this.tableMetadataBuilder.mergeWith(attributeToMerge.tableMetadata());
        }

        private static <T extends R, R> Stream<Attribute<T>> upcastingTransformForAttributes(Collection<Attribute<R>> superAttributes) {
            return superAttributes.stream().map(attribute -> attribute.transform(x -> x, null));
        }
    }
}

