/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.operations;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbEnhancedClientExtension;
import software.amazon.awssdk.enhanced.dynamodb.Expression;
import software.amazon.awssdk.enhanced.dynamodb.TableMetadata;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.extensions.WriteModification;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.BatchableWriteOperation;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.OperationContext;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.TableOperation;
import software.amazon.awssdk.enhanced.dynamodb.internal.operations.TransactableWriteOperation;
import software.amazon.awssdk.enhanced.dynamodb.model.PutItemEnhancedRequest;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.Put;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;
import software.amazon.awssdk.services.dynamodb.model.PutItemResponse;
import software.amazon.awssdk.services.dynamodb.model.PutRequest;
import software.amazon.awssdk.services.dynamodb.model.TransactWriteItem;
import software.amazon.awssdk.services.dynamodb.model.WriteRequest;

@SdkInternalApi
public class PutItemOperation<T>
implements BatchableWriteOperation<T>,
TransactableWriteOperation<T>,
TableOperation<T, PutItemRequest, PutItemResponse, Void> {
    private final PutItemEnhancedRequest<T> request;

    private PutItemOperation(PutItemEnhancedRequest<T> request) {
        this.request = request;
    }

    public static <T> PutItemOperation<T> create(PutItemEnhancedRequest<T> request) {
        return new PutItemOperation<T>(request);
    }

    @Override
    public PutItemRequest generateRequest(TableSchema<T> tableSchema, OperationContext operationContext, DynamoDbEnhancedClientExtension extension) {
        WriteModification transformation;
        if (!TableMetadata.primaryIndexName().equals(operationContext.indexName())) {
            throw new IllegalArgumentException("PutItem cannot be executed against a secondary index.");
        }
        TableMetadata tableMetadata = tableSchema.tableMetadata();
        tableMetadata.primaryPartitionKey();
        boolean alwaysIgnoreNulls = true;
        Map<String, AttributeValue> itemMap = tableSchema.itemToMap(this.request.item(), alwaysIgnoreNulls);
        WriteModification writeModification = transformation = extension != null ? extension.beforeWrite(itemMap, operationContext, tableMetadata) : null;
        if (transformation != null && transformation.transformedItem() != null) {
            itemMap = transformation.transformedItem();
        }
        PutItemRequest.Builder requestBuilder = PutItemRequest.builder().tableName(operationContext.tableName()).item(itemMap);
        requestBuilder = this.addExpressionsIfExist(requestBuilder, transformation);
        return (PutItemRequest)requestBuilder.build();
    }

    @Override
    public Void transformResponse(PutItemResponse response, TableSchema<T> tableSchema, OperationContext operationContext, DynamoDbEnhancedClientExtension extension) {
        return null;
    }

    @Override
    public Function<PutItemRequest, PutItemResponse> serviceCall(DynamoDbClient dynamoDbClient) {
        return arg_0 -> ((DynamoDbClient)dynamoDbClient).putItem(arg_0);
    }

    @Override
    public Function<PutItemRequest, CompletableFuture<PutItemResponse>> asyncServiceCall(DynamoDbAsyncClient dynamoDbAsyncClient) {
        return arg_0 -> ((DynamoDbAsyncClient)dynamoDbAsyncClient).putItem(arg_0);
    }

    @Override
    public WriteRequest generateWriteRequest(TableSchema<T> tableSchema, OperationContext operationContext, DynamoDbEnhancedClientExtension extension) {
        PutItemRequest putItemRequest = this.generateRequest(tableSchema, operationContext, extension);
        if (putItemRequest.conditionExpression() != null) {
            throw new IllegalArgumentException("A mapper extension inserted a conditionExpression in a PutItem request as part of a BatchWriteItemRequest. This is not supported by DynamoDb. An extension known to do this is the VersionedRecordExtension which is loaded by default unless overridden. To fix this use a table schema that does not have a versioned attribute in it or do not load the offending extension.");
        }
        return (WriteRequest)WriteRequest.builder().putRequest((PutRequest)PutRequest.builder().item(putItemRequest.item()).build()).build();
    }

    @Override
    public TransactWriteItem generateTransactWriteItem(TableSchema<T> tableSchema, OperationContext operationContext, DynamoDbEnhancedClientExtension dynamoDbEnhancedClientExtension) {
        PutItemRequest putItemRequest = this.generateRequest(tableSchema, operationContext, dynamoDbEnhancedClientExtension);
        Put put = (Put)Put.builder().item(putItemRequest.item()).tableName(putItemRequest.tableName()).conditionExpression(putItemRequest.conditionExpression()).expressionAttributeValues(putItemRequest.expressionAttributeValues()).expressionAttributeNames(putItemRequest.expressionAttributeNames()).build();
        return (TransactWriteItem)TransactWriteItem.builder().put(put).build();
    }

    private PutItemRequest.Builder addExpressionsIfExist(PutItemRequest.Builder requestBuilder, WriteModification transformation) {
        Expression mergedConditionExpression = transformation != null && transformation.additionalConditionalExpression() != null ? Expression.coalesce(this.request.conditionExpression(), transformation.additionalConditionalExpression(), " AND ") : this.request.conditionExpression();
        if (mergedConditionExpression != null) {
            requestBuilder = requestBuilder.conditionExpression(mergedConditionExpression.expression());
            if (mergedConditionExpression.expressionValues() != null && !mergedConditionExpression.expressionValues().isEmpty()) {
                requestBuilder = requestBuilder.expressionAttributeValues(mergedConditionExpression.expressionValues());
            }
            if (mergedConditionExpression.expressionNames() != null && !mergedConditionExpression.expressionNames().isEmpty()) {
                requestBuilder = requestBuilder.expressionAttributeNames(mergedConditionExpression.expressionNames());
            }
        }
        return requestBuilder;
    }
}

