/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb;

import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.enhanced.dynamodb.mapper.AttributeTypes;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkPublicApi
public final class AttributeValues {
    private static final AttributeValue NULL_ATTRIBUTE_VALUE = (AttributeValue)AttributeValue.builder().nul(Boolean.valueOf(true)).build();

    private AttributeValues() {
    }

    public static AttributeValue nullAttributeValue() {
        return NULL_ATTRIBUTE_VALUE;
    }

    public static AttributeValue stringValue(String value) {
        return AttributeTypes.stringType().objectToAttributeValue(value);
    }

    public static AttributeValue numberValue(Number value) {
        return AttributeTypes.numberType(null).objectToAttributeValue(value);
    }

    public static AttributeValue binaryValue(SdkBytes value) {
        return AttributeTypes.binaryType().objectToAttributeValue(value);
    }

    public static boolean isNullAttributeValue(AttributeValue attributeValue) {
        return attributeValue.nul() != null && attributeValue.nul() != false;
    }
}

