/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.model;

import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.enhanced.dynamodb.Expression;
import software.amazon.awssdk.enhanced.dynamodb.Key;

@SdkPublicApi
public final class DeleteItemEnhancedRequest {
    private final Key key;
    private final Expression conditionExpression;

    private DeleteItemEnhancedRequest(Builder builder) {
        this.key = builder.key;
        this.conditionExpression = builder.conditionExpression;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return DeleteItemEnhancedRequest.builder().key(this.key).conditionExpression(this.conditionExpression);
    }

    public Key key() {
        return this.key;
    }

    public Expression conditionExpression() {
        return this.conditionExpression;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeleteItemEnhancedRequest that = (DeleteItemEnhancedRequest)o;
        return this.key != null ? this.key.equals(that.key) : that.key == null;
    }

    public int hashCode() {
        return this.key != null ? this.key.hashCode() : 0;
    }

    public static final class Builder {
        private Key key;
        private Expression conditionExpression;

        private Builder() {
        }

        public Builder key(Key key) {
            this.key = key;
            return this;
        }

        public Builder conditionExpression(Expression conditionExpression) {
            this.conditionExpression = conditionExpression;
            return this;
        }

        public DeleteItemEnhancedRequest build() {
            return new DeleteItemEnhancedRequest(this);
        }
    }
}

