/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.mapper;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.core.BytesWrapper;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.internal.mapper.StaticAttributeType;
import software.amazon.awssdk.enhanced.dynamodb.mapper.AttributeType;
import software.amazon.awssdk.enhanced.dynamodb.mapper.AttributeValueType;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkPublicApi
public final class AttributeTypes {
    private AttributeTypes() {
    }

    public static AttributeType<Boolean> booleanType() {
        return StaticAttributeType.create(obj -> (AttributeValue)AttributeValue.builder().bool(obj).build(), AttributeValue::bool, AttributeValueType.BOOL);
    }

    public static AttributeType<String> stringType() {
        return StaticAttributeType.create(obj -> (AttributeValue)AttributeValue.builder().s(obj).build(), AttributeValue::s, AttributeValueType.S);
    }

    public static AttributeType<Integer> integerNumberType() {
        return AttributeTypes.numberType(Integer::parseInt);
    }

    public static AttributeType<Long> longNumberType() {
        return AttributeTypes.numberType(Long::parseLong);
    }

    public static AttributeType<Short> shortNumberType() {
        return AttributeTypes.numberType(Short::parseShort);
    }

    public static AttributeType<Byte> byteNumberType() {
        return AttributeTypes.numberType(Byte::parseByte);
    }

    public static AttributeType<Double> doubleNumberType() {
        return AttributeTypes.numberType(Double::parseDouble);
    }

    public static AttributeType<Float> floatNumberType() {
        return AttributeTypes.numberType(Float::parseFloat);
    }

    public static AttributeType<Set<Integer>> integerNumberSetType() {
        return AttributeTypes.numberSetType(Integer::parseInt);
    }

    public static AttributeType<Set<Long>> longNumberSetType() {
        return AttributeTypes.numberSetType(Long::parseLong);
    }

    public static AttributeType<Set<Short>> shortNumberSetType() {
        return AttributeTypes.numberSetType(Short::parseShort);
    }

    public static AttributeType<Set<Byte>> byteNumberSetType() {
        return AttributeTypes.numberSetType(Byte::parseByte);
    }

    public static AttributeType<Set<Double>> doubleNumberSetType() {
        return AttributeTypes.numberSetType(Double::parseDouble);
    }

    public static AttributeType<Set<Float>> floatNumberSetType() {
        return AttributeTypes.numberSetType(Float::parseFloat);
    }

    public static AttributeType<ByteBuffer> binaryType() {
        return StaticAttributeType.create(byteBuffer -> (AttributeValue)AttributeValue.builder().b(SdkBytes.fromByteBuffer((ByteBuffer)byteBuffer)).build(), attributeValue -> attributeValue.b().asByteBuffer(), AttributeValueType.B);
    }

    public static AttributeType<Set<ByteBuffer>> binarySetType() {
        return StaticAttributeType.create(bbSet -> (AttributeValue)AttributeValue.builder().bs((Collection)bbSet.stream().map(SdkBytes::fromByteBuffer).collect(Collectors.toList())).build(), attributeValue -> attributeValue.bs().stream().map(BytesWrapper::asByteBuffer).collect(Collectors.toSet()), AttributeValueType.BS);
    }

    public static AttributeType<Set<String>> stringSetType() {
        return StaticAttributeType.create(stringSet -> (AttributeValue)AttributeValue.builder().ss((Collection)stringSet).build(), attributeValue -> Collections.unmodifiableSet(new HashSet(attributeValue.ss())), AttributeValueType.SS);
    }

    public static <T> AttributeType<List<T>> listType(AttributeType<T> elementType) {
        return StaticAttributeType.create(list -> (AttributeValue)AttributeValue.builder().l((Collection)list.stream().map(elementType::objectToAttributeValue).collect(Collectors.toList())).build(), attributeValue -> attributeValue.l().stream().map(elementType::attributeValueToObject).collect(Collectors.toList()), AttributeValueType.L);
    }

    public static <T> AttributeType<Map<String, T>> mapType(AttributeType<T> mappedValueType) {
        return StaticAttributeType.create(map -> (AttributeValue)AttributeValue.builder().m(map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> mappedValueType.objectToAttributeValue(entry.getValue())))).build(), attributeValue -> attributeValue.m().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> mappedValueType.attributeValueToObject((AttributeValue)entry.getValue()))), AttributeValueType.M);
    }

    public static <T> AttributeType<T> documentMapType(TableSchema<T> documentSchema) {
        return StaticAttributeType.create(document -> (AttributeValue)AttributeValue.builder().m(documentSchema.itemToMap(document, false)).build(), attributeValue -> documentSchema.mapToItem(attributeValue.m()), AttributeValueType.M);
    }

    public static <T extends Number> AttributeType<T> numberType(Function<String, T> stringToNumber) {
        return StaticAttributeType.create(obj -> (AttributeValue)AttributeValue.builder().n(obj.toString()).build(), attributeValue -> (Number)stringToNumber.apply(attributeValue.n()), AttributeValueType.N);
    }

    private static <T extends Number> AttributeType<Set<T>> numberSetType(Function<String, T> stringToNumber) {
        return StaticAttributeType.create(nSet -> (AttributeValue)AttributeValue.builder().ns((Collection)nSet.stream().map(Object::toString).collect(Collectors.toList())).build(), attributeValue -> attributeValue.ns().stream().map(stringToNumber).collect(Collectors.toSet()), AttributeValueType.NS);
    }
}

